#define FREE(var)                           \
    do {                                    \
        if (NULL != (var)) {                \
            free(var);                      \
            var = NULL;                     \
        }                                   \
    } while(0)

#define REQUIRE_SUCCESS(status, label, msg) \
    do                                      \
    {                                       \
        if (HAILO_SUCCESS != (status))      \
        {                                   \
            printf(BOLDRED);                  \
            printf("-E- %s : (%d)\n",msg, status); \
            printf(RESET);                   \
            goto label;                     \
        }                                   \
    } while(0)

#define RESET   "\033[0m"
#define BLACK   "\033[30m"      /* Black */
#define RED     "\033[31m"      /* Red */
#define GREEN   "\033[32m"      /* Green */
#define YELLOW  "\033[33m"      /* Yellow */
#define BLUE    "\033[34m"      /* Blue */
#define MAGENTA "\033[35m"      /* Magenta */
#define CYAN    "\033[36m"      /* Cyan */
#define WHITE   "\033[37m"      /* White */
#define BOLDBLACK   "\033[1m\033[30m"      /* Bold Black */
#define BOLDRED     "\033[1m\033[31m"      /* Bold Red */
#define BOLDGREEN   "\033[1m\033[32m"      /* Bold Green */
#define BOLDYELLOW  "\033[1m\033[33m"      /* Bold Yellow */
#define BOLDBLUE    "\033[1m\033[34m"      /* Bold Blue */
#define BOLDMAGENTA "\033[1m\033[35m"      /* Bold Magenta */
#define BOLDCYAN    "\033[1m\033[36m"      /* Bold Cyan */
#define BOLDWHITE   "\033[1m\033[37m"      /* Bold White */

typedef struct write_thread_args_t {
    hailo_stream_info_t *input_stream_info;
    hailo_input_stream input_stream;
    hailo_status status;
    int output_streams_cnt;
    int num_images;
} write_thread_args_t;

typedef struct video_thread_args_t {
    hailo_stream_info_t *input_stream_info;
    const char *video_path;
    int num_images;
} video_thread_args_t;

typedef struct post_infer_thread_args_t {
    hailo_output_stream output_stream;
    hailo_stream_info_t *stream_info;
    int tid;
    int num_streams;
} post_infer_thread_args_t;

typedef struct recv_thread_args_t {
    hailo_stream_info_t *output_stream_info;
    hailo_output_stream output_stream;
    hailo_status status;
    int tid;
    int lat_counter;
    int num_streams;
    int write_log;
    int num_images;
} recv_thread_args_t;