#include <hailo/hailort.h>

#define FREE(var)          \
    do                     \
    {                      \
        if (NULL != (var)) \
        {                  \
            free(var);     \
            var = NULL;    \
        }                  \
    } while (0)

#define REQUIRE_SUCCESS(status, label, msg) \
    do                                      \
    {                                       \
        if (HAILO_SUCCESS != (status))      \
        {                                   \
            printf(BOLDRED);                  \
            printf("-E- %s : (%d)\n",msg, status); \
            printf(RESET);                   \
            goto label;                     \
        }                                   \
    } while (0)

typedef struct write_thread_args_t
{
    hailo_stream_info_t *input_stream_info;
    hailo_input_stream input_stream;
    hailo_status status;
    int output_streams_cnt;
    unsigned int num_images;
    size_t host_frame_size;
    size_t frame_hw_size;
    int write_log;
    int tid;
    int source_fps;
} write_thread_args_t;

typedef struct recv_thread_args_t
{
    hailo_stream_info_t *output_stream_info;
    hailo_output_stream output_stream;
    hailo_status status;
    int tid;
    unsigned int num_images;
    int num_streams;
    int write_log;
    size_t host_frame_size;
    size_t frame_hw_size;
} recv_thread_args_t;

typedef struct video_thread_args_t
{
    hailo_stream_info_t *input_stream_info;
    const char *video_path;
    int num_images;
} video_thread_args_t;


const char* get_direction_name(hailo_stream_direction_t dir) {
    switch (dir) {
        case HAILO_H2D_STREAM: return "Input";
        case HAILO_D2H_STREAM: return "Output";
        case HAILO_STREAM_DIRECTION_MAX_ENUM: return "Wrong";
    }
    return "Wrong";
}

const char *get_transform_string(hailo_stream_transform_mode_t transform)
{
    switch(transform) {
        case HAILO_STREAM_NO_TRANSFORM: return "NO";
        case HAILO_STREAM_TRANSFORM_COPY: return "COPY";
        case HAILO_STREAM_TRANSFORM_INPLACE: return "IN_PLACE";
        case HAILO_STREAM_MAX_ENUM:
        default: return "Wrong";
    }
}

const char *get_flags_string(int flags)
{
    switch(flags) {
        case 0: return "NONE";
        case 1: return "QUANT";
        case 2: return "TRANS";
        case 3: return "QT+TR";
        default: return "UNKNOWN";
    }
}

const char *get_type_string(int type)
{
    switch(type) {
        case 0: return "AUTO";
        case 1: return "UINT8";
        case 2: return "UINT16";
        case 3: return "FLOAT32";
        default: return "UNKNOWN";
    }
}

const char *get_order_string(int order)
{
    switch(order) {
        case 0: return "NHWC";
        case 1: return "NHCW";
        case 2: return "FCR";
        case 3: return "F8CR";
        case 5: return "NC";
        case 8: return "NMS";
        case 10: return "NCHW";
        default: return "UNKNOWN";
    }
}

#define RESET "\033[0m"
#define BLACK "\033[30m"              /* Black */
#define RED "\033[31m"                /* Red */
#define GREEN "\033[32m"              /* Green */
#define YELLOW "\033[33m"             /* Yellow */
#define BLUE "\033[34m"               /* Blue */
#define MAGENTA "\033[35m"            /* Magenta */
#define CYAN "\033[36m"               /* Cyan */
#define WHITE "\033[37m"              /* White */
#define BOLDBLACK "\033[1m\033[30m"   /* Bold Black */
#define BOLDRED "\033[1m\033[31m"     /* Bold Red */
#define BOLDGREEN "\033[1m\033[32m"   /* Bold Green */
#define BOLDYELLOW "\033[1m\033[33m"  /* Bold Yellow */
#define BOLDBLUE "\033[1m\033[34m"    /* Bold Blue */
#define BOLDMAGENTA "\033[1m\033[35m" /* Bold Magenta */
#define BOLDCYAN "\033[1m\033[36m"    /* Bold Cyan */
#define BOLDWHITE "\033[1m\033[37m"   /* Bold White */