#ifndef _EXAMPLE_DEVICE_H_
#define _EXAMPLE_DEVICE_H_

#include <time.h>
#include <net/if.h>
#include <vector>
#include <memory>
#include <unistd.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <dirent.h>
#include <linux/limits.h>
#include <hailo/hailort.h>
#include "stream_and_info.hpp"

#define NOF_STREAMS (6)
#define NSEC_IN_SEC (1e+9)
#define LATENCY_MEASUREMENTS (100)
#define MAX_OUTPUT_MUX_INFO_CAPACITY (16)

 
class example_device
{
private:
    hailo_eth_device_info_t device_info;
    hailo_pcie_device_info_t pcie_device_info;
    hailo_device device;
    hailo_jlf jlf;
    std::vector<InputStream> input_streams;
    //std::vector<hailo_output_stream> output_streams;
    std::vector<std::unique_ptr<OutputStream>> output_streams;
    hailo_stream_info_t all_stream_infos[NOF_STREAMS];
    struct timespec start_time;
    struct timespec end_time;
    struct timespec sent_clock_t[LATENCY_MEASUREMENTS];
    struct timespec recv_clock_t[NOF_STREAMS-1][LATENCY_MEASUREMENTS];
    std::string iface;
    std::string jlf_dir;
    unsigned int num_imgs;
    int write_log;
    int debug;

    hailo_status create_pcie_device();
    hailo_status create_eth_device();
    hailo_status print_debug_stats();
    const char** get_jlf_files_form_path(const char *dir_name, uint8_t *actual_number_of_jlfs_files);
    const char* get_direction_name(hailo_stream_direction_t dir);
    double calc_latency(int count);
    template <class T> void _recv_thread(void *args);
    template <class T> void _send_thread(void *args);
    template <class T> hailo_status read_data_from_device(OutputStream* output_stream);
    template <class T> hailo_status infer();
    void release_input_stream();
    void release_jlf();
    void release_device();
    double get_time_from_ts(struct timespec ts);


public:
    int output_stream_cnt;
    int input_stream_cnt;
    example_device(std::string& iface, std::string& jlf_path, unsigned int num_imgs, int write_log, int debug);
    ~example_device();
    template <class T> hailo_status activate_output_stream(hailo_stream_info_t& info);
    template <class T> hailo_status activate_input_stream(hailo_stream_info_t& info);
    void print_net_banner();
    void print_inference_stats();
    template <class T> hailo_status setup_device_for_inference();
    void release_output_streams();
    void run_inference();
};
#endif
