#!/bin/bash

declare -A COMPILER=( [x86_64]=/usr/bin/gcc 
                      [aarch64]=/usr/bin/aarch64-linux-gnu-gcc 
                      [armv7l]=/usr/bin/arm-linux-gnueabi-gcc )

HAILORT_ROOT=/home/${USER}/SDK/2.12.1/cpu_sdk/platform/hailort
for ARCH in x86_64 aarch64 armv7l
do
    echo "-I- Building ${ARCH}"
    HAILORT_LIB=${HAILORT_ROOT}/lib/${ARCH}/libhailort.so.0.5.0
    mkdir -p build/${ARCH}
    HAILORT_ROOT=${HAILORT_ROOT} cmake -H. -Bbuild/${ARCH} -DARCH=${ARCH} -DCMAKE_C_COMPILER=${COMPILER[${ARCH}]}
    cmake --build build/${ARCH}
done