#include <queue>
#include <string>
#include <vector>
#include <opencv2/opencv.hpp>
#include <opencv2/video/video.hpp>
#include <opencv2/highgui/highgui.hpp>

#include <example_source.hpp>
#include <example_utils.h>

using namespace std;
using namespace cv;

example_source::example_source(source_kind_t _source_kind, unsigned _num_of_rand_imgs=0, string _source_path="") {
    source_kind = _source_kind;
    num_of_rand_imgs = _num_of_rand_imgs;
    source_path = _source_path;

    cout << BOLDCYAN << "-I-----------------------------------------------" << endl;
    cout << "-I- Source: " << source_kind << endl;
    if (source_kind != Random) {
        cout << "-I- Source: " << source_path << endl;
    } else {
        cout << "-I- Source: #" << num_of_rand_imgs << " Random images" << endl;
    }
    cout << "-I-----------------------------------------------" << RESET << endl;
}

void example_source::_frame_lib_thread(void *args)
{
    video_thread_args_t *v_args = (video_thread_args_t *)args;
    Mat org_frame;
    vector<String> file_names;
    Mat pp_frame(v_args->input_stream_info->hw_shape.height, v_args->input_stream_info->hw_shape.height, CV_8UC3);
    unsigned int idx = 0;

    cout << BOLDCYAN << "-I-----------------------------------------------" << endl
                     << "-I- [Frames-thread] Output shape (" << v_args->input_stream_info->hw_shape.height << ", " << v_args->input_stream_info->hw_shape.height << ")" << endl
                     << "-I-----------------------------------------------" << 
            RESET    << endl;

    cv::glob(v_args->video_path, file_names, false);
    for (String file : file_names)
    {
        org_frame = imread(file);
        cout << "-I- [Frames-thread] Getting frame #" << idx++ << ":" << file << endl;

        if (org_frame.size() != pp_frame.size())
            resize(org_frame, pp_frame, pp_frame.size());

        input_image_queue_m.lock();
        input_image_queue.push(pp_frame.clone());
        input_image_queue_m.unlock();
    }
    // Mark the final frame
    pp_frame.data[0] = 17;
    pp_frame.data[1] = 71;
    pp_frame.data[2] = 17;
    pp_frame.data[3] = 71;
    idx++;
    input_image_queue_m.lock();
    input_image_queue.push(pp_frame);
    input_image_queue_m.unlock();
    cout << BOLDCYAN << "-I-----------------------------------------------" << endl
                     << "-I- [Frames-thread] FINISHED READING DIR - #" << idx << endl
                     << "-I-----------------------------------------------" 
         << RESET    << endl;
}

void example_source::_video_source_thread(void *args)
{
    video_thread_args_t *v_args = (video_thread_args_t *)args;
    Mat org_frame;
    Mat pp_frame(v_args->input_stream_info->hw_shape.height, v_args->input_stream_info->hw_shape.height, CV_8UC3);
    unsigned int idx = 0;
    VideoCapture cap(v_args->video_path);

    if (!cap.isOpened())
    {
        cout << "-E- Unable to open video stream" << endl;
        return;
    }
    Size shape = Size((int)cap.get(CV_CAP_PROP_FRAME_WIDTH), (int)cap.get(CV_CAP_PROP_FRAME_HEIGHT));

    cout << BOLDCYAN << "-I-----------------------------------------------" << endl;
    cout << "-I- [Video-thread] Input shape  (" << shape.width << ", " << shape.height << ")" << endl;
    cout << "-I- [Video-thread] Output shape (" << v_args->input_stream_info->hw_shape.height << ", " << v_args->input_stream_info->hw_shape.height << ")" << endl;
    cout << "-I-----------------------------------------------" << RESET << endl;

    while (true)
    {
        if (++idx % 500 == 0)
            cout << "-I- [Video-thread] Getting frame: " << idx << endl;
        cap >> org_frame;
        if (org_frame.empty())
            break;

        resize(org_frame, pp_frame, pp_frame.size());

        input_image_queue_m.lock();
        input_image_queue.push(pp_frame.clone());
        input_image_queue_m.unlock();
    }
    // Mark the final frame
    pp_frame.data[0] = 17;
    pp_frame.data[1] = 71;
    pp_frame.data[2] = 17;
    pp_frame.data[3] = 71;
    idx++;
    input_image_queue_m.lock();
    input_image_queue.push(pp_frame);
    input_image_queue_m.unlock();
    cout << BOLDCYAN << "-I-----------------------------------------------" << endl;
    cout << "-I- [Video-thread] FINISHED MOVIE STREAM - " << idx << endl;
    cout << "-I-----------------------------------------------" << RESET << endl;
    cap.release();
}