#ifndef _EXAMPLE_SOURCE_H_
#define _EXAMPLE_SOURCE_H_

#include <vector>
#include <queue>
#include <mutex>

#include <opencv2/opencv.hpp>
#include <opencv2/video/video.hpp>
#include <opencv2/highgui/highgui.hpp>

class example_source
{
public:
    enum source_kind_t { Video, Jpg, Random };
    std::queue<cv::Mat> input_image_queue;

    example_source(source_kind_t _source_kind, unsigned _num_of_rand_imgs, std::string _source_path);
    ~example_source();
    void _frame_lib_thread(void *args);
    void _video_source_thread(void *args);

private:
    source_kind_t source_kind;
    unsigned num_of_rand_imgs;
    std::string source_path;
    std::mutex input_image_queue_m;
};
#endif