/**
 * Copyright 2020 (C) Hailo Technologies Ltd.
 * All rights reserved.
 *  
 * Hailo Technologies Ltd. ("Hailo") disclaims any warranties, including, but not limited to,
 * the implied warranties of merchantability and fitness for a particular purpose.
 * This software is provided on an "AS IS" basis, and Hailo has no obligation to provide maintenance,
 * support, updates, enhancements, or modifications.
 *
 * You may use this software in the development of any project.
 * You shall not reproduce, modify or distribute this software without prior written permission.
 **/
/**
 * @ file main.cpp
 * This example demonstrates the basic data-path on HailoRT.
 * The program scans for Hailo-8 devices connected to a provided Ethernet interface, generates random dataset,
 * and runs it through the device.
 **/

#include "example_device.hpp"
#include <iostream>
#include <thread>
#include <functional>

void thread_wrapper(std::string &iface, std::string &jlf_dir, unsigned int &num_img)
{
    example_device dev(iface, jlf_dir, num_img, 0, 0);
    dev.run_inference();
}

int main(int argc, char **argv)
{
    std::string jlf_dir = "./JLFs";
    std::string iface = "pcie";
    int opt;
    unsigned int num_img = 100;
    int debug = 0;
    int write_log = 0;

    while ((opt = getopt(argc, argv, "i:j:n:dl")) != -1)
    {
        switch (opt)
        {
        case 'j':
            jlf_dir = optarg;
            break;
        case 'i':
            iface = optarg;
            break;
        case 'n':
            num_img = atoi(optarg);
            break;
        case 'd':
            debug = 1;
            break;
        case 'l':
            write_log = 1;
            break;
        case '?':
            fprintf(stderr, "Option -%c requires an argument.\n", optopt);
        default:
            fprintf(stderr, "Usage: %s -i INTERFACE -j JLF-DIR [-n NUM-IMAGES]\n\n", argv[0]);
            fprintf(stderr, "     -i INTERFACE      The device interface, defaults to \'pcie\', if using Ethernet name the Host port\n");
            fprintf(stderr, "     -j JLF-DIR        The JLFs directory, defaults to \'./JLFs/\'\n");
            fprintf(stderr, "     -n NUM-IMAGES     The number of images to process, defaults to 100\n");
            fprintf(stderr, "     -d                Read and print debug registers from FW\n");
            fprintf(stderr, "     -l                Each receive thread will write a log file\n");
            exit(EXIT_FAILURE);
        }
    }
    try
    {
        std::cout << "-I- TEST STARTS" << std::endl;
        std::thread t0(thread_wrapper, std::ref(iface), std::ref(jlf_dir), std::ref(num_img));
        t0.join();
        std::cout << "-I- TEST ENDED" << std::endl;
    }
    catch (const std::exception &e)
    {
        std::cout << e.what();
    }
}