#ifndef _STREAM_AND_INFO_H_
#define _STREAM_AND_INFO_H_

#include <vector>
#include <memory>

#include <hailo/hailort.h>

class OutputStream {
public:
    OutputStream();
    OutputStream(hailo_output_stream output_stream, hailo_stream_info_t stream_info);

    virtual ~OutputStream();

    OutputStream& operator = (const OutputStream& other);
    
    hailo_output_stream& GetStream();
    hailo_stream_info_t GetStreamInfo() const;
    size_t GetHostFrameSize() const;
    bool GetIsMux() const;

    void SetStream(hailo_output_stream output_stream);
    void SetStreamInfo(hailo_stream_info_t stream_info);
    void SetHostFrameSize(hailo_stream_info_t info, hailo_stream_params_t params);

protected:
    hailo_output_stream                 m_output_stream;   
    hailo_stream_info_t                 m_stream_info;
    size_t                              m_host_frame_size;
    bool                                m_is_mux;
};

class OutputStreamMux : public OutputStream {
public:
    OutputStreamMux();
    OutputStreamMux(std::vector<hailo_stream_info_t> mux_stream_info, size_t output_mux_info_size, hailo_output_stream& output_stream, hailo_stream_info_t& stream_info);

    virtual ~OutputStreamMux();

    OutputStreamMux& operator = (const OutputStreamMux& other);

    std::vector<hailo_stream_info_t> GetMuxStreamInfo() const;
    size_t GetMuxInfoSize() const;

    void SetMuxStreamInfo(std::vector<hailo_stream_info_t> mux_stream_info);
    void SetMuxInfoSize(size_t mux_info_size);

    // template<class T>
    void ConfigurDemuxRawBuffers(std::vector<hailo_stream_raw_buffer_t>& demux_raw_buffers, std::vector< std::vector<float32_t> >& host_output_muxed_data);

private:
    std::vector<hailo_stream_info_t>    m_mux_stream_info;
    size_t                              m_output_mux_info_size;
};

class InputStream {
public:
    InputStream();

    ~InputStream();
    
    hailo_input_stream GetStream() const;
    hailo_stream_info_t GetStreamInfo() const;
    bool GetIsMux() const;
    size_t GetHostFrameSize() const;
    
    void SetStream(hailo_input_stream input_stream);
    void SetStreamInfo(hailo_stream_info_t stream_info);
    void SetIsMux();
    void SetHostFrameSize(hailo_stream_info_t info, hailo_stream_params_t params);
    
private:
    hailo_input_stream      m_input_stream;
    hailo_stream_info_t     m_stream_info;
    bool                    m_is_mux;
    size_t                  m_host_frame_size;
};

#endif