#ifndef _EXAMPLE_DEVICE_H_
#define _EXAMPLE_DEVICE_H_

#include <time.h>
#include <net/if.h>
#include <vector>
#include <memory>
#include <unistd.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <dirent.h>
#include <linux/limits.h>
#include <example_utils.hpp>
#include <condition_variable>
#include <queue>
#include <future>
#include <opencv2/opencv.hpp>
#include <opencv2/video/video.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <hailo/hailort.h>

#define NOF_STREAMS (6)
#define NSEC_IN_SEC (1e+9)
#define LATENCY_MEASUREMENTS (100)
#define MAX_OUTPUT_MUX_INFO_CAPACITY (16)

class example_device
{
private:
    hailo_eth_device_info_t device_info;
    hailo_pcie_device_info_t pcie_device_info;
    hailo_device device;
    hailo_hef hef;
    hailo_network_group network_group;
    hailo_activated_network_group active_net_g;
    hailo_input_stream input_stream;
    hailo_output_stream output_streams[NOF_STREAMS];
    hailo_stream_info_t all_stream_infos[NOF_STREAMS];
    struct timespec start_time;
    struct timespec end_time;
    struct timespec sent_clock_t[LATENCY_MEASUREMENTS];
    struct timespec recv_clock_t[NOF_STREAMS-1][LATENCY_MEASUREMENTS];
    std::string iface;
    std::string hef_file;
    unsigned int num_imgs;
    unsigned int batch_size;
    int write_log;
    int debug;
    bool yolo_post;
    qp_zp_scale_t qp_zp_scale;
    bool use_one_rx_thrd;

    std::queue<cv::Mat> input_image_queue;
    pthread_mutex_t input_image_queue_m = PTHREAD_MUTEX_INITIALIZER;

    // std::queue< std::vector<uint8_t> > post_infer_queue[NOF_STREAMS-1];
    // pthread_mutex_t post_infer_queue_m = PTHREAD_MUTEX_INITIALIZER;
    void* _frame_lib_thread(void *args);
    void* _video_source_thread(void *args);
    void* _send_from_source_thread(void *args);
    std::string source_path;
    bool source_is_video(std::string& path);
    template <class T> void _recv_thread1(std::future<void> &futureObj);

    void init_qp_zp_struct();
    hailo_status create_pcie_device();
    hailo_status create_eth_device();
    hailo_status print_debug_stats();
    template<class T> hailo_status set_stream_infos(hailo_input_stream_params_by_name_t *input_stream_params, hailo_output_stream_params_by_name_t *output_stream_params);
    const char* get_direction_name(hailo_stream_direction_t dir);
    double calc_latency(int count);
    template <class T> void _recv_thread(void *args);
    template <class T> void _send_thread(void *args);
    template <class T> hailo_status infer();
    void release_input_stream();
    void release_hef();
    void release_device();
    double get_time_from_ts(struct timespec ts);


public:
    size_t output_stream_cnt;
    size_t input_stream_cnt;
    example_device(std::string& iface, std::string& hef_file, unsigned int num_imgs, unsigned int batch, int write_log, int debug, bool yolo_post, std::string source_path);
    ~example_device();
    hailo_status create_and_load_hef();
    void print_net_banner();
    void print_inference_stats();
    template <class T> hailo_status setup_device_for_inference();
    void release_output_streams();
    void run_inference();
    hailo_status activate_network_group(hailo_input_stream_params_by_name_t *input_stream_params, hailo_output_stream_params_by_name_t *output_stream_params);
    size_t host_input_frame_size;
    size_t host_output_frame_size[NOF_STREAMS];
};
#endif
