/**
 * Copyright 2020 (C) Hailo Technologies Ltd.
 * All rights reserved.
 *  
 * Hailo Technologies Ltd. ("Hailo") disclaims any warranties, including, but not limited to,
 * the implied warranties of merchantability and fitness for a particular purpose.
 * This software is provided on an "AS IS" basis, and Hailo has no obligation to provide maintenance,
 * support, updates, enhancements, or modifications.
 *
 * You may use this software in the development of any project.
 * You shall not reproduce, modify or distribute this software without prior written permission.
 **/
/**
 * @ file main.cpp
 * This example demonstrates the basic data-path on HailoRT.
 * The program scans for Hailo-8 devices connected to a provided Ethernet interface, generates random dataset,
 * and runs it through the device.
 **/

#include "example_device.hpp"
#include "example_utils.hpp"
#include <iostream>
#include <thread>
#include <functional>

void thread_wrapper(std::string &iface, std::string &hef_file, unsigned int &batch, unsigned int &num_img, int &write_log, int &debug, bool &yolo_post, std::string &source_input)
{
    example_device dev(iface, hef_file, num_img, batch, write_log, debug, yolo_post, source_input);
    dev.run_inference();
}

int main(int argc, char **argv)
{
    std::string hef = "";
    std::string iface = "pcie";
    std::string video_path = "";
    bool yolo_post = false;
    int opt;
    unsigned int num_img = 100;
    unsigned int batch = 1;
    int debug = 0;
    int write_log = 0;

    while ((opt = getopt(argc, argv, "i:c:n:v:dly")) != -1)
    {
        switch (opt)
        {
        case 'c':
            hef = optarg;
            break;
        case 'b':
            batch = atoi(optarg);
            break;
        case 'i':
            iface = optarg;
            break;
        case 'n':
            num_img = atoi(optarg);
            break;
        case 'd':
            debug = 1;
            break;
        case 'l':
            write_log = 1;
            break;
        case 'v':
            video_path = optarg;
            break;
        case 'y':
            yolo_post = true;
            break;
        case '?':
            fprintf(stderr, "Option -%c requires an argument.\n", optopt);
        default:
            fprintf(stderr, "Usage: %s -i INTERFACE -j JLF-DIR [-n NUM-IMAGES]\n\n", argv[0]);
            fprintf(stderr, "     -c HEF            The HEF Configuration file\n");
            fprintf(stderr, "     -n NUM-IMAGES     The number of images to process, defaults to 100\n");
            fprintf(stderr, "     -v VIDEO FILE     Path to an input video file\n");
            fprintf(stderr, "     -i INTERFACE      The device interface, defaults to \'pcie\', if using Ethernet name the Host port\n");
            fprintf(stderr, "     -b BATCH          Batch size, defaults to 1, relevant only to context-switch\n");
            fprintf(stderr, "     -y                Do YOLOv5 post-processing\n");
            fprintf(stderr, "     -d                Read and print debug registers from FW\n");
            fprintf(stderr, "     -l                Each receive thread will write a log file\n");
            exit(EXIT_FAILURE);
        }
    }
    try
    {
        std::cout << CYAN << "-I- TEST STARTS" << RESET << std::endl;
        if (yolo_post==true && video_path.empty()) {
            std::cout << RED << "-W- Received no input source (Video or images) and YOLOv5, aborting" << RESET << std::endl;
            exit(0);
        }
        std::thread t0(thread_wrapper, std::ref(iface), std::ref(hef), std::ref(num_img), std::ref(batch), std::ref(write_log), std::ref(debug), std::ref(yolo_post), std::ref(video_path));
        t0.join();
        std::cout << CYAN << "-I- TEST ENDED" << RESET << std::endl;
    }
    catch (const std::exception &e)
    {
        std::cout << e.what();
    }
}