#!/bin/bash

declare -A COMPILER=( [x86_64]=/usr/bin/gcc 
                      [aarch64]=/usr/bin/aarch64-linux-gnu-gcc 
                      [armv7l]=/usr/bin/arm-linux-gnueabi-gcc )

HAILORT_ROOT=/home/nadave/SDK/platform-sw/hailort
HAILORT_ROOT=/local/users/nadave/SDK/3.9.0/platform/hailort

for ARCH in x86_64
do
    echo "-I- Building ${ARCH}"
    mkdir -p build/${ARCH}
    export CXX=g++-9
    LIB_VER=2.9.0 HAILORT_ROOT=${HAILORT_ROOT} cmake -H. -Bbuild/${ARCH} -DARCH=${ARCH} -DCMAKE_C_COMPILER=${COMPILER[${ARCH}]}
    cmake --build build/${ARCH}
done
if [[ -f "hailort.log" ]]; then
    rm hailort.log
fi
