#include "stream_and_info.hpp"

InputStream::InputStream()
:m_is_mux(false)
{}
InputStream::~InputStream()
{}
hailo_input_stream InputStream::GetStream() const {
    return m_input_stream;
}
hailo_stream_info_t InputStream::GetStreamInfo() const {
    return m_stream_info;
}
bool InputStream::GetIsMux() const {
    return m_is_mux;
}
size_t InputStream::GetHostFrameSize() const {
    return m_host_frame_size;
}
void InputStream::SetStream(hailo_input_stream input_stream) {
    m_input_stream = input_stream;
}
void InputStream::SetStreamInfo(hailo_stream_info_t stream_info) {
    m_stream_info = stream_info;
}
void InputStream::SetIsMux() {
    m_is_mux = true;
}
void InputStream::SetHostFrameSize(hailo_stream_info_t info, hailo_stream_params_t params) {
    m_host_frame_size = hailo_get_host_frame_size(&info, &params);
}

//////////////////////////////////////////////////////////////////////////////////////
OutputStream::OutputStream()
{}
OutputStream::OutputStream(hailo_output_stream output_stream, hailo_stream_info_t stream_info)
: m_output_stream(output_stream),
m_stream_info(stream_info),
m_is_mux(stream_info.is_mux)
{}
OutputStream::~OutputStream() 
{}
OutputStream& OutputStream::operator = (const OutputStream& other) {
    if(this != &other) {
        m_output_stream = other.m_output_stream;
        m_stream_info = other.m_stream_info;
    }
    return *this;
}
bool OutputStream::GetIsMux() const {
    return m_is_mux;
}
hailo_output_stream& OutputStream::GetStream() {
    return m_output_stream;
}
hailo_stream_info_t OutputStream::GetStreamInfo() const {
    return m_stream_info;
}
size_t OutputStream::GetHostFrameSize() const {
    return m_host_frame_size;
}
void OutputStream::SetStream(hailo_output_stream output_stream) {
    m_output_stream = output_stream;
}
void OutputStream::SetStreamInfo(hailo_stream_info_t stream_info) {
    m_stream_info = stream_info;
    m_is_mux = stream_info.is_mux;
}
void OutputStream::SetHostFrameSize(hailo_stream_info_t info, hailo_stream_params_t params) {
    m_host_frame_size = hailo_get_host_frame_size(&info, &params);
}

//////////////////////////////////////////////////////////////////////////////////////////


OutputStreamMux::OutputStreamMux() 
{}

OutputStreamMux::OutputStreamMux(std::vector<hailo_stream_info_t> mux_stream_info, size_t output_mux_info_size, hailo_output_stream& output_stream, hailo_stream_info_t& stream_info)
: OutputStream(output_stream, stream_info),
m_mux_stream_info(mux_stream_info),
m_output_mux_info_size(output_mux_info_size)
{}

OutputStreamMux::~OutputStreamMux()
{}

OutputStreamMux& OutputStreamMux::operator = (const OutputStreamMux& other) {
    if(this != &other) {
        m_mux_stream_info = other.m_mux_stream_info;
        m_output_mux_info_size = other.m_output_mux_info_size;
        m_output_stream = other.m_output_stream;
        m_stream_info = other.m_stream_info;
    }
    return *this;
}

std::vector<hailo_stream_info_t> OutputStreamMux::GetMuxStreamInfo() const {
    return m_mux_stream_info;
}

size_t OutputStreamMux::GetMuxInfoSize() const {
    return m_output_mux_info_size;
}

void OutputStreamMux::SetMuxStreamInfo(std::vector<hailo_stream_info_t> mux_stream_info) {
    m_mux_stream_info = mux_stream_info;
}

void OutputStreamMux::SetMuxInfoSize(size_t mux_info_size) {
    m_output_mux_info_size = mux_info_size;
}

void OutputStreamMux::ConfigurDemuxRawBuffers(std::vector<hailo_stream_raw_buffer_t>& demux_raw_buffers, std::vector< std::vector<float32_t> >& host_output_muxed_data) {
    hailo_format_t demux_format;
    hailo_stream_params_t params;
    
    demux_raw_buffers.resize(m_output_mux_info_size);

    demux_format.type = HAILO_FORMAT_TYPE_UINT8;
    demux_format.order = HAILO_FORMAT_ORDER_NHWC;
    demux_format.flags = HAILO_FORMAT_FLAGS_QUANTIZE;
    
    // if (typeid(T) == typeid(float32_t)) {
    demux_format.type = HAILO_FORMAT_TYPE_FLOAT32;
    demux_format.flags = HAILO_FORMAT_FLAGS_NONE;
    // }
    params.user_buffer_format = demux_format;
    for(unsigned int i = 0; i < m_output_mux_info_size; ++i) {
        size_t host_frame_size = hailo_get_host_frame_size(&m_mux_stream_info[i], &params);
        //size_t host_frame_size = m_mux_stream_info[i].shape_size;
        host_output_muxed_data[i].resize(host_frame_size);
        demux_raw_buffers[i].buffer = host_output_muxed_data[i].data(); 
        demux_raw_buffers[i].offset = 0;
        demux_raw_buffers[i].size = host_frame_size;
        demux_raw_buffers[i].shape = m_mux_stream_info[i].shape;
        demux_raw_buffers[i].format = demux_format;
    }
}
