/*
 * Copyright (c) 2016 Qualcomm Technologies, Inc.
 * All Rights Reserved.
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 */
package com.qualcomm.qti.snpe.imageclassifiers;

import android.app.Activity;
import android.app.FragmentTransaction;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;

import com.qualcomm.qti.snpe.imageclassifiers.detector.Bbox;
import com.qualcomm.qti.snpe.imageclassifiers.detector.RetinaDetector;
import com.qualcomm.qti.snpe.imageclassifiers.detector.Slicing;
import com.qualcomm.qti.snpe.imageclassifiers.thread.AISliceMergingThread;
import com.qualcomm.qti.snpe.imageclassifiers.thread.AiSlicingThread;
import com.qualcomm.qti.snpe.imageclassifiers.thread.ImageSlice;
import com.qualcomm.qti.snpe.imageclassifiers.thread.SliceCropBox;

import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.opencv_java;
import org.opencv.osgi.OpenCVNativeLoader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

import static com.qualcomm.qti.snpe.imageclassifiers.detector.RetinaDetector.IMG_HEIGHT;
import static com.qualcomm.qti.snpe.imageclassifiers.detector.RetinaDetector.IMG_WIDTH;

public class MainActivity extends Activity {
    private static final String LOGTAG = MainActivity.class.getSimpleName();
    private static final int MAX_THREAD = 7;
    int noRows = 2;
    int noCols = 3;
    double rowsOverlap = 0.15;
    double colsOverlap = 0.15;
    int startInd = 0;
    private Slicing Slice;


    private Bitmap loadBmpImage(int Input){
        BitmapFactory.Options o = new BitmapFactory.Options();
        o.inScaled = false;
        Bitmap testBmp = BitmapFactory.decodeResource(getResources(),Input,o);

        return testBmp;
    }


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Loader.load(opencv_java.class);

        List<AiSlicingThread> listAiSlicingThread = new ArrayList<>();
        AISliceMergingThread aiSliceMergingThread = new AISliceMergingThread(this);
        aiSliceMergingThread.start();

        for (int i=0 ;i< MAX_THREAD; ++i){
            AiSlicingThread aiSlicingThread = new AiSlicingThread(this.getApplication(), this, aiSliceMergingThread);
            listAiSlicingThread.add(i,aiSlicingThread);
            listAiSlicingThread.get(i).setName("aithread" + i);
            listAiSlicingThread.get(i).start();
        }

        int frameId= 0;
        Bitmap originalBitmap = loadBmpImage(R.raw.test_image);

        List<SliceCropBox> listSliceCrop = new ArrayList<>();
        listSliceCrop.add(new SliceCropBox(0,0,1280,718));
        listSliceCrop.add(new SliceCropBox(0,0,458,385));
        listSliceCrop.add(new SliceCropBox(396,0,488,385));
        listSliceCrop.add(new SliceCropBox(822,0,457,385));
        listSliceCrop.add(new SliceCropBox(0,333,458,385));
        listSliceCrop.add(new SliceCropBox(396,333,488,385));
        listSliceCrop.add(new SliceCropBox(822,333,457,385));


        int currentIndexThread = 0;
        int i=0;

        while (i<100){
            try {
                Thread.sleep(30);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            i++;
            for (SliceCropBox sliceCropBox : listSliceCrop) {
                if (currentIndexThread > listAiSlicingThread.size() - 1){
                    currentIndexThread = 0;
                }
                listAiSlicingThread.get(currentIndexThread).addSlicedImage(new ImageSlice(frameId, originalBitmap, sliceCropBox));
                currentIndexThread++;
            }
            frameId++;

        }



    }





    @Override
    protected void onDestroy() {
        super.onDestroy();

    }




}
