package com.qualcomm.qti.snpe.imageclassifiers.detector;

import org.opencv.core.Mat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class Slicing {
    int imgHeight;
    int imgWidth;
    int noRows;
    int noCols;
    double rowsOverlap;
    double colsOverlap;
    int startInd = 0;
    public Slicing(int imgHeight_,
            int imgWidth_,
            int noRows_,
            int noCols_,
            double rowsOverlap_,
            double colsOverlap_,
            int startInd_)
    {
        this.imgHeight = imgHeight_;
        this.imgWidth = imgWidth_;
        this.noCols = noCols_;
        this.noRows = noRows_;
        this.rowsOverlap = rowsOverlap_;
        this.colsOverlap = colsOverlap_;
        this.startInd = startInd_;
    }
    public ArrayList<Integer>  getSlice()
    {
        ArrayList<Integer> divisionList = new ArrayList<Integer>();
        ArrayList<Integer> rowVals = new ArrayList<Integer>();
        ArrayList<Integer> colVals = new ArrayList<Integer>();
        ArrayList<Integer> zeroRows = new ArrayList<Integer>();
        ArrayList<Integer> finalRows = new ArrayList<Integer>();
        ArrayList<Integer> zeroCols = new ArrayList<Integer>();
        ArrayList<Integer> finalCols = new ArrayList<Integer>();
        ArrayList<Integer> yMins = new ArrayList<Integer>();
        ArrayList<Integer> xMins = new ArrayList<Integer>();
        ArrayList<Integer> yMaxs = new ArrayList<Integer>();
        ArrayList<Integer> xMaxs = new ArrayList<Integer>();
        ArrayList<Integer> xMinMesh = new ArrayList<Integer>();
        ArrayList<Integer> yMinMesh = new ArrayList<Integer>();
        ArrayList<Integer> xMaxMesh = new ArrayList<Integer>();
        ArrayList<Integer> yMaxMesh = new ArrayList<Integer>();

        int divisionH = this.imgHeight / noRows;
        int remainderH = this.imgHeight % noRows;
        int divisionW = imgWidth/ noCols;
        int remainderW = imgWidth % noCols;
        int rowsOverlapPixels = (int)(rowsOverlap*divisionH/2);
        int colsOverlapPixels = (int)(colsOverlap*divisionW/2);
        int startH = (int)(Math.floor(remainderH/2));
        int finalH = (int)(this.imgHeight - Math.ceil((remainderH/2)));
        int startW = (int)(Math.floor(remainderW/2));
        int finalW = (int)(this.imgWidth - Math.ceil(remainderW/2));
        int rowValsInit = 0;
        while (rowValsInit<finalH+1){
            if (rowValsInit<finalH+1){
                rowVals.add(rowValsInit);
            }
            rowValsInit += divisionH;
        }
        int colValsInit = 0;
        while (colValsInit<finalW+1){
            if (colValsInit<finalW+1){
                colVals.add(colValsInit);
            }
            colValsInit += divisionW;
        }
        for (int i=0 ;i < this.noRows;i++){
            zeroRows.add(0);
        }
        for (int i=0 ;i < this.noRows;i++){
            finalRows.add(finalH);
        }
        for (int i=0 ;i < this.noCols;i++){
            zeroCols.add(0);
        }
        for (int i=0 ;i < this.noCols;i++){
            finalCols.add(finalW);
        }

        for (int i = 0; i < zeroRows.size(); i++){
            yMins.add(Math.max(zeroRows.get(i),rowVals.get(i)-rowsOverlapPixels));
        }
        for (int i = 0; i < zeroCols.size(); i++){
            xMins.add(Math.max(zeroCols.get(i),colVals.get(i)-colsOverlapPixels));
        }

        for (int i = 0; i < finalRows.size(); i++){
            yMaxs.add(Math.min(finalRows.get(i),rowVals.get(i+1)+rowsOverlapPixels));
        }
        for (int i = 0; i < finalCols.size(); i++){
            xMaxs.add(Math.min(finalCols.get(i),colVals.get(i+1)+colsOverlapPixels));
        }
        for (int i = 0; i < yMins.size(); i++){
            for (int j = 0 ; j < xMins.size();i++)
            {
                xMinMesh.add(xMins.get(j));
            }

//            xMinMesh.add(xMins);
        }
//        for (int i =0 ; i< xMins.size(); i++){
//            for (int j = 0; j < yMins.size();i++){
//                yMinMeshLine.add(yMins.get(j));
//                yMinMesh.add(yMinMeshLine);
//                yMinMeshLine.clear();
//            }
//        }

        return xMinMesh;
    }
}
