# lgtm-distributed

![Version: 1.0.1](https://img.shields.io/badge/Version-1.0.1-informational?style=flat-square) ![Type: application](https://img.shields.io/badge/Type-application-informational?style=flat-square) ![AppVersion: 6.59.4](https://img.shields.io/badge/AppVersion-6.59.4-informational?style=flat-square)

Umbrella chart for a distributed Loki, Grafana, Tempo and Mimir stack

**Homepage:** <https://grafana.com/oss/>

## Maintainers

| Name | Email | Url |
| ---- | ------ | --- |
| timberhill |  |  |

## Source Code

* <https://grafana.github.io/helm-charts>
* <https://github.com/grafana/grafana>
* <https://github.com/grafana/loki>
* <https://github.com/grafana/mimir>
* <https://github.com/grafana/tempo>

## Requirements

| Repository | Name | Version |
|------------|------|---------|
| https://grafana.github.io/helm-charts | grafana(grafana) | ^6.59.4 |
| https://grafana.github.io/helm-charts | loki(loki-distributed) | ^0.74.3 |
| https://grafana.github.io/helm-charts | mimir(mimir-distributed) | ^5.0.0 |
| https://grafana.github.io/helm-charts | tempo(tempo-distributed) | ^1.6.4 |

## Values

| Key | Type | Default | Description |
|-----|------|---------|-------------|
| grafana.datasources | object | `{"datasources.yaml":{"apiVersion":1,"datasources":[{"isDefault":false,"name":"Loki","type":"loki","uid":"loki","url":"http://{{ .Release.Name }}-loki-gateway"},{"isDefault":true,"name":"Mimir","type":"prometheus","uid":"prom","url":"http://{{ .Release.Name }}-mimir-nginx/prometheus"},{"isDefault":false,"jsonData":{"lokiSearch":{"datasourceUid":"loki"},"serviceMap":{"datasourceUid":"prom"},"tracesToLogsV2":{"datasourceUid":"loki"},"tracesToMetrics":{"datasourceUid":"prom"}},"name":"Tempo","type":"tempo","uid":"tempo","url":"http://{{ .Release.Name }}-tempo-query-frontend:3100"}]}}` | Grafana data sources config. Connects to all three by default |
| grafana.datasources."datasources.yaml".datasources | list | `[{"isDefault":false,"name":"Loki","type":"loki","uid":"loki","url":"http://{{ .Release.Name }}-loki-gateway"},{"isDefault":true,"name":"Mimir","type":"prometheus","uid":"prom","url":"http://{{ .Release.Name }}-mimir-nginx/prometheus"},{"isDefault":false,"jsonData":{"lokiSearch":{"datasourceUid":"loki"},"serviceMap":{"datasourceUid":"prom"},"tracesToLogsV2":{"datasourceUid":"loki"},"tracesToMetrics":{"datasourceUid":"prom"}},"name":"Tempo","type":"tempo","uid":"tempo","url":"http://{{ .Release.Name }}-tempo-query-frontend:3100"}]` | Datasources linked to the Grafana instance. Override if you disable any components. |
| grafana.enabled | bool | `true` | Deploy Grafana if enabled. See [upstream readme](https://github.com/grafana/helm-charts/tree/main/charts/grafana#configuration) for full values reference. |
| loki.enabled | bool | `true` | Deploy Loki if enabled. See [upstream readme](https://github.com/grafana/helm-charts/tree/main/charts/loki-distributed#values) for full values reference. |
| mimir | object | `{"alertmanager":{"resources":{"requests":{"cpu":"20m"}}},"compactor":{"resources":{"requests":{"cpu":"20m"}}},"distributor":{"resources":{"requests":{"cpu":"20m"}}},"enabled":true,"ingester":{"replicas":2,"resources":{"requests":{"cpu":"20m"}},"zoneAwareReplication":{"enabled":false}},"minio":{"resources":{"requests":{"cpu":"20m"}}},"overrides_exporter":{"resources":{"requests":{"cpu":"20m"}}},"querier":{"replicas":1,"resources":{"requests":{"cpu":"20m"}}},"query_frontend":{"resources":{"requests":{"cpu":"20m"}}},"query_scheduler":{"replicas":1,"resources":{"requests":{"cpu":"20m"}}},"rollout_operator":{"resources":{"requests":{"cpu":"20m"}}},"ruler":{"resources":{"requests":{"cpu":"20m"}}},"store_gateway":{"resources":{"requests":{"cpu":"20m"}},"zoneAwareReplication":{"enabled":false}}}` | Mimir chart values. Resources are set to a minimum by default. |
| mimir.enabled | bool | `true` | Deploy Mimir if enabled. See [upstream values.yaml](https://github.com/grafana/mimir/blob/main/operations/helm/charts/mimir-distributed/values.yaml) for full values reference. |
| tempo.enabled | bool | `true` | Deploy Tempo if enabled.  See [upstream readme](https://github.com/grafana/helm-charts/blob/main/charts/tempo-distributed/README.md#values) for full values reference. |
| tempo.ingester.replicas | int | `1` |  |

----------------------------------------------
Autogenerated from chart metadata using [helm-docs v1.8.1](https://github.com/norwoodj/helm-docs/releases/v1.8.1)
