package main

import (
	"context"
	"demootel/common/otelutil"
	"demootel/demo"
	demohttp "demootel/demo/api/http"
	"demootel/demo/tracing"
	"errors"
	"fmt"
	"go.opentelemetry.io/otel"
	"net/http"
	"time"
)

//func newExporter(ctx context.Context) (trace.SpanExporter, error) {
//	return otlptracehttp.New(ctx)
//}

//func initTracer() (*trace.TracerProvider, error) {
//	tp := trace.NewTracerProvider(
//		trace.WithSampler(trace.AlwaysSample()), // Adjust sampling strategy as needed
//	)
//	otel.SetTracerProvider(tp)
//	return tp, nil
//}

func main() {
	// Set up OpenTelemetry.
	otelShutdown, err := otelutil.SetupOTelSDK(context.Background())
	if err != nil {
		return
	}
	// Handle shutdown properly so nothing leaks.
	defer func() {
		err = errors.Join(err, otelShutdown(context.Background()))
	}()

	//tp, err := initTracer()
	//if err != nil {
	//	panic(err)
	//}
	//defer func() {
	//	err := tp.Shutdown(context.Background())
	//	if err != nil {
	//		panic(err)
	//	}
	//}()

	ts := time.Now().UnixMilli()
	fmt.Printf("Ts: %d\n", ts)

	svc := newService()
	svc = tracing.DemoTracingMiddleware(svc, otel.Tracer("demo-vdn"))
	errs := make(chan error, 2)

	go startHTTPServer(demohttp.MakeHandler(svc), "8001", errs)
	fmt.Printf("Listening on port: %d\n", 8001)
	err = <-errs
}

// newService create new instantiate
func newService() demo.Service {

	// Create new pricing service
	svc := demo.NewNoDb()
	return svc
}

// Start HTTP Server
func startHTTPServer(handler http.Handler, port string, errs chan error) {
	p := fmt.Sprintf(":%s", port)
	errs <- http.ListenAndServe(p, handler)
}
