package http

import (
	"context"
	"demootel/common/errors"
	"demootel/demo"
	"encoding/json"
	"fmt"
	kithttp "github.com/go-kit/kit/transport/http"
	"github.com/go-zoo/bone"
	"go.opentelemetry.io/contrib/instrumentation/net/http/otelhttp"
	"net/http"
	"net/http/pprof"
)

const (
	contentType = "application/json"
	offset      = "offset"
	limit       = "limit"
	name        = "name"
	metadata    = "metadata"

	defOffset = 0
	defLimit  = 100
)

var (
	errUnsupportedContentType = errors.New("unsupported content type")
	errNotFoundUserId         = errors.New("not found user Id")
)

// MakeHandler returns a HTTP handler for API endpoints.
func MakeHandler(svc demo.Service) *bone.Mux {
	//opts := []kithttp.ServerOption{
	//	kithttp.ServerErrorEncoder(encodeError),
	//}

	r := bone.New()

	r.HandleFunc("/debug/pprof/", pprof.Index)
	r.HandleFunc("/debug/pprof/cmdline", pprof.Cmdline)
	r.HandleFunc("/debug/pprof/profile", pprof.Profile)
	r.HandleFunc("/debug/pprof/symbol", pprof.Symbol)
	r.HandleFunc("/debug/pprof/trace", pprof.Trace)

	r.Post("/demo-otel/call", otelhttp.NewHandler(kithttp.NewServer(
		demoOtelCallEndpoint(svc),
		decodeIotEventSave,
		encodeResponse,
	), "demo-otel/call",
		otelhttp.WithMessageEvents(otelhttp.ReadEvents, otelhttp.WriteEvents)))

	return r
}

func decodeIotEventSave(_ context.Context, r *http.Request) (interface{}, error) {
	//if !strings.Contains(r.Header.Get("Content-Type"), contentType) {
	//        return nil, errUnsupportedContentType
	//}
	//req := iotevent.IotEventSaveReq{}
	//if err := json.NewDecoder(r.Body).Decode(&req); err != nil {
	//        return nil, errors.Wrap(iotevent.ErrMalformedEntity, err)
	//}
	////parse UserId from Header. Override UserId in request body if any
	//userId := r.Header.Get("X-User")
	//if userId == "" {
	//        return nil, errNotFoundUserId
	//}
	//req.UserId = userId
	fmt.Printf("decodeIotEventSave\n")

	return "Nothing", nil
}

// Encode
func encodeResponse(_ context.Context, w http.ResponseWriter, response interface{}) error {
	w.Header().Set("Content-Type", contentType)
	err := json.NewEncoder(w).Encode(response)
	return err
}
