package demo

import (
	"context"
	"errors"
	"fmt"
	"go.opentelemetry.io/otel"
	"time"
)

var (
	// ErrMalformedEntity indicates malformed entity specification (e.g. invalid username or password).
	ErrMalformedEntity    = errors.New("malformed entity specification")
	ErrConflict           = errors.New("conflict")
	ErrUnauthorizedAccess = errors.New("ErrUnauthorizedAccess")
	ErrForbidden          = errors.New("ErrForbidden")
)

var loc, _ = time.LoadLocation("Asia/Ho_Chi_Minh")

type Service interface {
	Call(ctx context.Context) (interface{}, error)
}

var _ Service = (*demoOtelService)(nil)

type demoOtelService struct {
}

func (svc demoOtelService) Call(ctx context.Context) (interface{}, error) {

	ctx, span := otel.Tracer("service-demo-call").Start(ctx, "Demo-Call")
	fmt.Printf("Call\n")
	defer span.End()
	return "OK", nil
}

func NewNoDb() Service {
	return &demoOtelService{}
}

type Response struct {
	Code int         `json:"code"`
	Msg  string      `json:"msg"`
	Data interface{} `json:"data,omitempty"`
}
