package tracing

import (
	"context"
	"demootel/demo"
	"go.opentelemetry.io/otel/trace"
)

const (
	callOp = "call_op"
)

type demoTracingMiddleware struct {
	svc    demo.Service
	tracer trace.Tracer
}

func DemoTracingMiddleware(svc demo.Service, tracer trace.Tracer) demo.Service {
	return &demoTracingMiddleware{svc, tracer}
}

func (m demoTracingMiddleware) Call(ctx context.Context) (interface{}, error) {
	ctx, span := createSpan(ctx, m.tracer, callOp)
	defer span.End()
	return m.svc.Call(ctx)
}

func createSpan(ctx context.Context, tracer trace.Tracer, opName string) (context.Context, trace.Span) {
	return tracer.Start(ctx, opName) //Create nested span (parents-child) automatically if the current context has a span already
}
