package demo2

import (
	"context"
	"errors"
	"fmt"
	"go.opentelemetry.io/otel"
	"time"
)

var (
	// ErrMalformedEntity indicates malformed entity specification (e.g. invalid username or password).
	ErrMalformedEntity    = errors.New("malformed entity specification")
	ErrConflict           = errors.New("conflict")
	ErrUnauthorizedAccess = errors.New("ErrUnauthorizedAccess")
	ErrForbidden          = errors.New("ErrForbidden")
)

var loc, _ = time.LoadLocation("Asia/Ho_Chi_Minh")

type Service interface {
	Call(ctx context.Context) (interface{}, error)
}

var _ Service = (*demo2OtelService)(nil)

type demo2OtelService struct {
}

func (svc demo2OtelService) Call(ctx context.Context) (interface{}, error) {

	ctx, span := otel.Tracer("service-demo2-call").Start(ctx, "Demo2-Call")
	fmt.Printf("Call2\n")
	defer span.End()
	return "OK", nil
}

func NewNoDb() Service {
	return &demo2OtelService{}
}

type Response struct {
	Code int         `json:"code"`
	Msg  string      `json:"msg"`
	Data interface{} `json:"data,omitempty"`
}
