package main

import (
	"context"
	"demootel/common/otelutil"
	"demootel/demo2"
	demohttp "demootel/demo2/api/http"
	"demootel/demo2/tracing"
	"errors"
	"fmt"
	"go.opentelemetry.io/otel"
	"net/http"
	"time"
)

//func newExporter(ctx context.Context) (trace.SpanExporter, error) {
//	return otlptracehttp.New(ctx)
//}

//func initTracer() (*trace.TracerProvider, error) {
//	tp := trace.NewTracerProvider(
//		trace.WithSampler(trace.AlwaysSample()), // Adjust sampling strategy as needed
//	)
//	otel.SetTracerProvider(tp)
//	return tp, nil
//}

func main() {
	// Set up OpenTelemetry.
	otelShutdown, err := otelutil.SetupOTelSDK(context.Background())
	if err != nil {
		return
	}
	// Handle shutdown properly so nothing leaks.
	defer func() {
		err = errors.Join(err, otelShutdown(context.Background()))
	}()

	//tp, err := initTracer()
	//if err != nil {
	//	panic(err)
	//}
	//defer func() {
	//	err := tp.Shutdown(context.Background())
	//	if err != nil {
	//		panic(err)
	//	}
	//}()

	ts := time.Now().UnixMilli()
	fmt.Printf("Ts: %d\n", ts)

	svc := newService()
	svc = tracing.Demo2TracingMiddleware(svc, otel.Tracer("demo2-vdn"))
	errs := make(chan error, 2)

	httpPort := "8002"
	go startHTTPServer(demohttp.MakeHandler(svc), httpPort, errs)
	fmt.Printf("Listening on port: %s", httpPort)
	err = <-errs
}

// newService create new instantiate
func newService() demo2.Service {

	// Create new pricing service
	svc := demo2.NewNoDb()
	return svc
}

// Start HTTP Server
func startHTTPServer(handler http.Handler, port string, errs chan error) {
	p := fmt.Sprintf(":%s", port)
	errs <- http.ListenAndServe(p, handler)
}
