package tracing

import (
	"context"
	"demootel/demo2"
	"go.opentelemetry.io/otel/trace"
)

const (
	callOp = "call2_op"
)

type demo2TracingMiddleware struct {
	svc    demo2.Service
	tracer trace.Tracer
}

func Demo2TracingMiddleware(svc demo2.Service, tracer trace.Tracer) demo2.Service {
	return &demo2TracingMiddleware{svc, tracer}
}

func (m demo2TracingMiddleware) Call(ctx context.Context) (interface{}, error) {
	ctx, span := createSpan(ctx, m.tracer, callOp)
	defer span.End()
	return m.svc.Call(ctx)
}

func createSpan(ctx context.Context, tracer trace.Tracer, opName string) (context.Context, trace.Span) {
	return tracer.Start(ctx, opName) //Create nested span (parents-child) automatically if the current context has a span already
}
