package com.securityandsafetythings.examples.aiapp.aicore.aiLibs;

import android.graphics.Bitmap;

import androidx.annotation.NonNull;

import com.securityandsafetythings.examples.aiapp.aicore.mediapool.MediaNode;

import org.opencv.core.Mat;

import java.util.HashMap;
import java.util.Map;

public abstract class InferenceResult implements Concludable{
    static final String LOGTAG = InferenceResult.class.getSimpleName();
    /** This class is implemented follow the component design-pattern, each result can be the result
     *  of another result
     *  */
    protected MediaNode processMedia;
    protected Map<ResultName, InferenceResult> listResult = null;
    protected Mat processRBBMat;

    /** This enum define all the result-name of all algorithm result in aiLibs
     * Therefore, each algorithm has its private result-name
     * TODO: New implemented algorithm need to assign its name here -> IMPORTANT !!!!
     * */
    public enum ResultName {
        box                 ("box"),
        faceDetect          ("FD"),
        featureExtracted    ("feature"),
        faceRecognized      ("FR"),
        humanDetect         ("HD"),
        motionDetect        ("Motion"),
        trueFace            ("trueFace"),
        track               ("track"),
        faceAlign           ("faceAlign"),
        iqa                 ("iqa"),
        licencePlateAlign   ("LPAlign"),
        licencePlateDetect  ("LPD"),
        vehicleDetect       ("VHD"),
        ocr                 ("OCR");

        private final String resultname;
        ResultName(String resultname) {
            this.resultname = resultname;
        }
    }

    /** Constructor */
    public InferenceResult(MediaNode processMedia) {
        this.processMedia = processMedia;
    }

    public InferenceResult(MediaNode processMedia, Mat processRBBMat) {
        this.processMedia = processMedia;
        this.processRBBMat = processRBBMat;
    }

    public InferenceResult(@NonNull InferenceResult previousInference) {
        this.processMedia = previousInference.getProcessMedia();
        this.processRBBMat = previousInference.getProcessRBBMat();
    }

    /***/
    public abstract ResultName getResultName();

    /** return inferenceResult if this is the resultName itself or exist resultName in this listResult */
    public boolean hasResult(@NonNull ResultName resultName) {
        /*if (getResultName().resultname.equals(resultName.resultname)){
            return true;
        }*/
        //Log.d(LOGTAG,"check List result = " + listResult);
        return listResult.containsKey(resultName);
    }

    public void addResult(InferenceResult inferenceResult){
        if (listResult == null) {
            listResult = new HashMap<>();
        }
        listResult.put(inferenceResult.getResultName(), inferenceResult);
    }

    public InferenceResult getInferenceResult(@NonNull ResultName resultName){
        //Log.d(LOGTAG,"check List result = " + listResult);
        return listResult.get(resultName);
    }

    public Bitmap getProcessBitmap(){
        return processMedia.getBitmap();
    }

    public MediaNode getProcessMedia(){
        return processMedia;
    }

    public void freeMediaNode(){
        processMedia.free();
        //processMedia = null;
    }

    public void setProcessMedia(MediaNode processMedia) {
        this.processMedia = processMedia;
    }

    public Mat getProcessRBBMat() {
        return processRBBMat;
    }

    @Override
    public void summarizeInferenceDataInfo(){
        /** clear all data process of root and child node in Inference tree, also call summariseInfo on
         * each inference-node in tree  */
        this.processMedia = null;
        if (listResult != null) {
            for (Map.Entry<ResultName, InferenceResult> child : listResult.entrySet()) {
                child.getValue().processMedia = null;
                child.getValue().summarizeInferenceDataInfo();
            }
        }
    }
}


