package com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.algorithmbasic;

import android.graphics.Bitmap;
import android.graphics.PointF;

import androidx.annotation.NonNull;

import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.Bbox;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.sorttrack.TrackBox;

import org.opencv.android.Utils;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfDouble;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.imgproc.Imgproc;

public class FaceQualifier extends BasicInference {
    /** iqa threshold */
    public static final double IQA_BLUR_THRESHOLD = 2.25f;

    @Override
    public IQAResult runInference(@NonNull InferenceResult inputInference) {
        TrackBox trackBox = (TrackBox) inputInference;
        Bbox box = (Bbox) trackBox.getInferenceResult(InferenceResult.ResultName.box);
        double blur = getFaceBur(box);

        Point[] landmarks = box.landmarks;
        double eyeDist = Math.sqrt(Math.pow(landmarks[0].x-landmarks[1].x,2) + Math.pow(landmarks[0].y-landmarks[1].y,2));
        float width = box.x2 - box.x1;
        float eyesRatio =  (float)(eyeDist/width);

        IQAResult iqaResult = new IQAResult(inputInference, blur, eyeDist, eyesRatio);
        trackBox.addResult(iqaResult);
        return iqaResult;
    }

    private double getFaceBur(@NonNull Bbox box){
        Rect rectCrop = new Rect((int) (box.x1), (int) (box.y1),
                (int) ((box.x2 - box.x1)), (int) (box.y2 - box.y1) );

        /* Calculate blur */
        //WARNING cant optimize this code by put rgb image from detect step (frame is not 1080p)
        Bitmap imageBmp = box.getProcessBitmap();
        Mat frameRgba = new Mat();
        Mat frameRgb = new Mat();
        Utils.bitmapToMat(imageBmp, frameRgba);
        Imgproc.cvtColor(frameRgba, frameRgb, Imgproc.COLOR_RGBA2RGB);
        Mat cropMat = frameRgb.submat(rectCrop);

        Mat matGray = new Mat();
        Imgproc.cvtColor(cropMat, matGray, Imgproc.COLOR_BGR2GRAY);

        Mat destination = new Mat();
        Imgproc.Laplacian(matGray, destination, 3);
        MatOfDouble median = new MatOfDouble();
        MatOfDouble std = new MatOfDouble();
        Core.meanStdDev(destination, median, std);
        return Math.pow(std.get(0,0)[0], 2.0);
    }


    @Override
    public void release() {

    }
}
