package com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.algorithmbasic;

import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;

import java.util.HashMap;

public class FaceRecognizeResult extends InferenceResult {
    public static final String UNKNOWN = "Unknown";
    private String label;
    private String labelId; // faceId defined by server while add face
    private float minDistance;
    private int index;
    private HashMap<String, Float> scoreMap = new HashMap<>();

    /**
     * Default Constructor: use for create unknown face when database have no person
     * @param previousInference
     */
    public FaceRecognizeResult(InferenceResult previousInference) {
        super(previousInference);
        label = UNKNOWN;
        minDistance = 10;
        index = -1;
        labelId = "";
    }


    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public float getMinDistance() {
        return minDistance;
    }

    public void setMinDistance(float minDistance) {
        this.minDistance = minDistance;
    }

    public int getIndex() {
        return index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getLabelId() {
        return labelId;
    }

    public void setLabelId(String labelId) {
        this.labelId = labelId;
    }

    public HashMap<String, Float> getScoreMap() {
        return scoreMap;
    }

    public void setScoreMap(HashMap<String, Float> scoreMap) {
        this.scoreMap = scoreMap;
    }

    public void setScoreMapByLabel(String label, float score){
        if (scoreMap.containsKey(label)){
            score += scoreMap.get(label);
        }
        scoreMap.put(label, score);
    }

    public float getScoreMapByLabel(String label){
        return scoreMap.get(label);
    }

    @Override
    public ResultName getResultName() {
        return ResultName.faceRecognized;
    }
}
