package com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.motion;

import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;

import org.opencv.core.Mat;

public class MotionResult extends InferenceResult {
    public Mat foregroundMat;
    boolean isMotion = false;
    boolean runtimeMode = false; // gray = true & rgb = false

    /**
     * Constructor
     * @param previousInference
     * @param foregroundMat
     * @param isMotion
     */
    public MotionResult(InferenceResult previousInference, Mat foregroundMat, boolean isMotion, boolean runtimeMode) {
        super(previousInference);
        this.foregroundMat = foregroundMat;
        this.isMotion = isMotion;
        this.runtimeMode = runtimeMode;
    }

    public Mat getForegroundMat() {
        return foregroundMat;
    }

    public void setForegroundMat(Mat foregroundMat) {
        this.foregroundMat = foregroundMat;
    }

    public boolean isMotion() {
        return isMotion;
    }

    public void setMotion(boolean motion) {
        isMotion = motion;
    }

    public boolean getRuntimeMode() {
        return runtimeMode;
    }

    public void setRuntimeMode(boolean runtimeMode) {
        this.runtimeMode = runtimeMode;
    }

    @Override
    public ResultName getResultName() {
        return ResultName.motionDetect;
    }
}