package com.securityandsafetythings.examples.aiapp.utilities;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;

import androidx.annotation.NonNull;

import org.opencv.android.Utils;
import org.opencv.core.Mat;

import java.io.File;
import java.io.FileOutputStream;

public class ImageUtils {
    static final String LOGTAG = ImageUtils.class.getSimpleName();


    public static void saveBitmapToCache(@NonNull Context context, final Bitmap bitmap, String filename){
        File root = context.getCacheDir();
        String saveDir = root + File.separator + "save_image";
        final File myDir = new File(saveDir);

        if (!myDir.mkdirs()) {
            Log.i("","Make dir failed");
        }

        final File file = new File(myDir,  filename + ".png");
        if (file.exists()) {
            file.delete();
        }

        Log.d(LOGTAG, "save Image to path = " + saveDir);

        try {
            final FileOutputStream out = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 99, out);
            out.flush();
            out.close();
        } catch (final Exception e) {
            e.printStackTrace();
        }
    }

    /** Not optimized function -> use for test only */
    public static void saveMatToCache(Context context, @NonNull final Mat saveMatRGBA, String filename){
        Bitmap saveBitmap = Bitmap.createBitmap(saveMatRGBA.cols(), saveMatRGBA.rows(), Bitmap.Config.ARGB_8888);
        Utils.matToBitmap(saveMatRGBA, saveBitmap);
        saveBitmapToCache(context, saveBitmap, filename);
    }

}
