package com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.align;

import static org.opencv.imgproc.Imgproc.COLOR_RGBA2RGB;

import android.graphics.Bitmap;

import androidx.annotation.NonNull;

import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.Bbox;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.face.FDResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.NativeInference;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.sorttrack.TrackBox;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.sorttrack.TrackResult;

import org.jetbrains.annotations.NotNull;
import org.opencv.android.Utils;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.imgproc.Imgproc;

import java.util.List;

/** Face Aligner is implement as a step of face detection and recognized process */
public class FaceAligner extends NativeInference {
    /** variable for cache-pre-process process*/
    private final Mat processMatRGBA;
    private final Mat processMatRGB;
    private final Mat processMat32F;

    public static native void nativeAlign(long frameCvPtr, long frameRetPtr, float[][] landmarkObjArr);

    public FaceAligner() {
        processMatRGBA = new Mat();
        processMatRGB = new Mat();
        processMat32F = new Mat();
    }

    /** This method will return the faceAlign results mapped with Bbox in listBbox of FDResult
     * Beside, this also need input as an FDResult so that it will return the same object
     * with input
     * Input: FDResult
     * Output: input with FaceAlignResult added in each Bbox in listBbox of input
     * */
    public TrackResult runInference(@NotNull TrackResult inputInference) {
        List<TrackBox> listTrackBox = inputInference.getTrackList();

        Bitmap inputBitmap = inputInference.getProcessBitmap();
        Utils.bitmapToMat(inputBitmap, processMatRGBA);
        Imgproc.cvtColor(processMatRGBA , processMatRGB , 3);//COLOR_RGBA2RGB
        processMatRGB.convertTo(processMat32F, CvType.CV_32F);

        for (TrackBox trackBox : listTrackBox){
            Bbox box = (Bbox) trackBox.getInferenceResult(InferenceResult.ResultName.box);
            Mat matAlignedFace = prepareAlignNative(processMat32F, box);
            /* pre-process for next step: true face and face-feature extraction */
            matAlignedFace.convertTo(matAlignedFace, CvType.CV_32F, 1.0/255, 0);
            FaceAlignResult alignResult = new FaceAlignResult(box, matAlignedFace);
            trackBox.addResult(alignResult);
        }

        return inputInference;
    }

    /** Default method runInference
     * Input: FDResult which contain list Bbox
     * Output: FDResult with added FaceAligned Result in each Bbox
     * */
    @Override
    public InferenceResult runInference(@NonNull InferenceResult inputInference) {
        FDResult fdResult = (FDResult) inputInference;
        List<Bbox> listBox = fdResult.getBboxList();

        Bitmap inputBitmap = inputInference.getProcessBitmap();
        Utils.bitmapToMat(inputBitmap, processMatRGBA);
        Imgproc.cvtColor(processMatRGBA , processMatRGB , COLOR_RGBA2RGB);
        processMatRGB.convertTo(processMat32F, CvType.CV_32F);

        for (Bbox box : listBox){
            Mat matAlignedFace = prepareAlignNative(processMat32F, box);
            /* pre-process for next step: true face and face-feature extraction */
            matAlignedFace.convertTo(matAlignedFace, CvType.CV_32F, 1.0/255, 0);
            FaceAlignResult alignResult = new FaceAlignResult(box, matAlignedFace);
            box.addResult(alignResult);
        }

        return fdResult;
    }

    public Mat prepareAlignNative(@NotNull Mat frameCv, @NotNull Bbox box) {
        float[][] landmarks = {
                {(float)box.landmarks[0].x, (float)box.landmarks[0].y},
                {(float)box.landmarks[1].x, (float)box.landmarks[1].y},
                {(float)box.landmarks[2].x, (float)box.landmarks[2].y},
                {(float)box.landmarks[3].x, (float)box.landmarks[3].y},
                {(float)box.landmarks[4].x, (float)box.landmarks[4].y}
        };

        Mat faceAligned = new Mat();//112, 112, CV_32FC1);
        nativeAlign(frameCv.getNativeObjAddr(), faceAligned.getNativeObjAddr(), landmarks);

        return faceAligned;
    }

    @Override
    public void release() {

    }

}
