package com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference;

import android.app.Application;
import android.content.Context;

import com.qualcomm.qti.snpe.NeuralNetwork;
import com.qualcomm.qti.snpe.Tensor;

import org.jetbrains.annotations.NotNull;

import java.util.Map;

public abstract class DLCInference extends ModelInference{
    //protected final String[] OUTPUT_LAYERS;
    protected Context context;
    protected Application application;
    protected NeuralNetwork network = null;


    protected DLCInference(int image_width, int image_height) {
        super(image_width, image_height);

        /* Set default constance and initial allocation*/
    }

    @SafeVarargs
    protected final void releaseTensors(@NotNull Map<String, ? extends Tensor>... tensorMaps) {
        for (Map<String, ? extends Tensor> tensorMap: tensorMaps) {
            for (Tensor tensor: tensorMap.values()) {
                tensor.release();
            }
        }
    }

}
