package com.securityandsafetythings.examples.aiapp.aicore.aiprocess;

import android.app.Application;
import android.content.Context;

import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.motion.MotionDetector;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.motion.MotionResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.sorttrack.TrackResult;

public class AIFaceMotionProcessor extends AIFaceProcessor{
    static final String LOGTAG = AIFaceMotionProcessor.class.getSimpleName();
    public long lastMotionTime = 0;
    private static final long DELAY_MOTION_ACTIVE = 5000;

    /** Algorithm object */
    private MotionDetector motionDetector;

    public AIFaceMotionProcessor(Context mContext, Application mApplication, AIProcess nextProcess) {
        super(mContext, mApplication, nextProcess);
        this.motionDetector = new MotionDetector(false);
        this.setName("FaceMotion");
    }

    @Override
    public TrackResult onProcess(InferenceResult inputInference) {
        long startMotion = System.currentTimeMillis();
        MotionResult motionResult = motionDetector.runInference(inputInference);
        long motionTime = System.currentTimeMillis() - startMotion;
        //Log.d(LOGTAG +"_checkRuntime", "motion runtime = " +motionTime +"ms");

        boolean isHaveMotion = motionResult.isMotion();

        if (isHaveMotion){
            lastMotionTime = System.currentTimeMillis();
            return super.onProcess(motionResult);
        } else if (System.currentTimeMillis() - lastMotionTime < DELAY_MOTION_ACTIVE) {
            return super.onProcess(motionResult);
        }
        return null;
    }

    @Override
    public void onProcessEnd() {
        super.onProcessEnd();
        motionDetector.release();
    }
}
