package com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.algorithmbasic;

import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;

public class IQAResult extends InferenceResult {
    private double blur;
    private double eyeDistance;
    private float eyeRatio;
    /**
     * Constructor
     *
     * @param previousInference
     * @param blur
     * @param eyeDistance
     * @param eyeRatio
     */
    public IQAResult(InferenceResult previousInference, double blur, double eyeDistance, float eyeRatio) {
        super(previousInference);
        this.eyeDistance = eyeDistance;
        this.eyeRatio = eyeRatio;
        this.blur = blur;
    }

    public double getBlur() {
        return blur;
    }

    public void setBlur(double blur) {
        this.blur = blur;
    }

    public double getEyeDistance() {
        return eyeDistance;
    }

    public void setEyeDistance(double eyeDistance) {
        this.eyeDistance = eyeDistance;
    }

    public float getEyeRatio() {
        return eyeRatio;
    }

    public void setEyeRatio(float eyeRatio) {
        this.eyeRatio = eyeRatio;
    }

    @Override
    public ResultName getResultName() {
        return ResultName.iqa;
    }
}
