package com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.sorttrack;

import androidx.annotation.NonNull;

import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.Bbox;

import java.util.ArrayList;
import java.util.List;

public class TrackBox extends InferenceResult {
    private NativeTrackBox nativeTrackBox;

    /** attribute for utilities*/
    public static final int MAX_CACHE_TRACK = 10;
    private List<Bbox> listTrackCache = new ArrayList<>();
    private float iouWithFirstCache = 1f;
    private String zoneId = "";
    private String label = "";
    private float motionScore = 0f;
    private long timeLife = System.currentTimeMillis();

    /**
     * Constructor
     * @param nativeTrackBox
     * @param previousInference
     */
    public TrackBox(InferenceResult previousInference, NativeTrackBox nativeTrackBox) {
        super(previousInference);
        this.nativeTrackBox = nativeTrackBox;
    }

    @Override
    public ResultName getResultName() {
        return null;
    }

    public int getTrackID(){
        return nativeTrackBox.id;
    }

    public NativeTrackBox getNativeTrackBox() {
        return nativeTrackBox;
    }

    public List<Bbox> getListTrackCache() {
        return listTrackCache;
    }

    public void addBboxToCache(Bbox bbox){
        if (listTrackCache.size() >= MAX_CACHE_TRACK){
            listTrackCache.remove(0);
        }
        listTrackCache.add(bbox);

    }

    public void updateTrackBox(@NonNull TrackBox newUpdateTrack){
        this.nativeTrackBox = newUpdateTrack.getNativeTrackBox();
        this.processMedia = newUpdateTrack.getProcessMedia();
        this.listResult = newUpdateTrack.listResult;

        this.zoneId = newUpdateTrack.getZoneId();
        this.motionScore = newUpdateTrack.getMotionScore();
        this.timeLife = newUpdateTrack.getTimeLife();
    }

    /** this method use for set value to iou attribute
     */
    public float checkBoxIntersection(Bbox currBbox) {
        if (!listTrackCache.isEmpty()){
            Bbox firstBbox = listTrackCache.get(0);
            // Determine the (x, y) - coordinates of the intersected rectangle
            float xA = Math.max(firstBbox.x1, currBbox.x1);
            float yA = Math.max(firstBbox.y1, currBbox.y1);
            float xB = Math.min(firstBbox.x2, currBbox.x2);
            float yB = Math.min(firstBbox.y2, currBbox.y2);

            if (xB < xA || yB < yA) {
                return (float) 0.0;
            }
            // Compute the area of intersected rectangle
            float interArea = (xB - xA) * (yB - yA);

            // Compute the area of both the predicted and ground-truth rectangles
            float predictedArea = (currBbox.x2 - currBbox.x1) *
                    (currBbox.y2 - currBbox.y1);
            float groundTruthArea = (firstBbox.x2 - firstBbox.x1) *
                    (firstBbox.y2 - firstBbox.y1);

            // Compute the intersection over union by taking the intersection
            // area and dividing it by the sum of prediction + ground-truth
            // areas - the intersection area
            float iou = interArea / (predictedArea + groundTruthArea - interArea);
//              Log.d("LastBbox", "index: " + currBbox.trackId + " iou: " + iou);
            return iou;
        } else {
            return 1f;
        }
    }

    public float getIouWithFirstCache() {
        return iouWithFirstCache;
    }

    public void setIouWithFirstCache(float iouWithFirstCache) {
        this.iouWithFirstCache = iouWithFirstCache;
    }

    public String getZoneId() {
        return zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public float getMotionScore() {
        return motionScore;
    }

    public void setMotionScore(float motionScore) {
        this.motionScore = motionScore;
    }

    public long getTimeLife() {
        return timeLife;
    }

    public void setTimeLife(long timeLife) {
        this.timeLife = timeLife;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public class NativeTrackBox {
        /**
         * This class implement as the return of c++ native tracker from kalman sort-track algorithm
         */
        public int frame;
        public int id; // id -> trackID - trackId of input detect box from tracking's output
        public float x1;
        public float y1;
        public float width;
        public float height;
        public int boxId; // index of detected box on tracking's input
        //other
        public int update_hits;
        public int predict_hits;

        public float vx;
        public float vy;
    }

    @Override
    public void summarizeInferenceDataInfo() {
        super.summarizeInferenceDataInfo();

    }
}
