#pragma once

#include "IBGS.h"
#include "vibe-background-sequential.h"

namespace bgslibrary
{
    namespace algorithms
    {
        class ViBe : public IBGS
        {
        private:
            static const int DEFAULT_NUM_SAMPLES = 20;
            static const int DEFAULT_MATCH_THRESH = 20;
            static const int DEFAULT_MATCH_NUM = 2;
            static const int DEFAULT_UPDATE_FACTOR = 16;

            static const int NIGHT_MODE_MATCH_THRESH = 4;
            static const int NIGHT_MODE_MATCH_NUM = 2;
            static const int NIGHT_MODE_UPDATE_FACTOR = 4;
        private:
            //int numberOfSamples;
            int matchingThreshold;
            int matchingNumber;
            int updateFactor;
            vibe::vibeModel_Sequential_t* model;

        public:
            ViBe():matchingThreshold(DEFAULT_MATCH_THRESH),
                   matchingNumber(DEFAULT_MATCH_NUM),
                   updateFactor(DEFAULT_UPDATE_FACTOR),
                   model(nullptr)
                   {
                model = vibe::libvibeModel_Sequential_New();
            };
            ~ViBe(){
                vibe::libvibeModel_Sequential_Free(model);
                __android_log_print(ANDROID_LOG_VERBOSE, "debugMotion", "release model");
            };

            void process(const cv::Mat &img_input, cv::Mat &img_output, cv::Mat &img_bgmodel, bool mode)
            {
                init(img_input, img_output, img_bgmodel);

                if (img_input.empty())
                    return;

                if (firstTime) {
                    /* Create a buffer for the output image. */
                    //img_output = cv::Mat(img_input.rows, img_input.cols, CV_8UC1);

                    /* Initialization of the ViBe model. */
                    if (mode){
                        // if true mean using nightMode
                        matchingThreshold = NIGHT_MODE_MATCH_THRESH;
                        matchingNumber = NIGHT_MODE_MATCH_NUM;
                        updateFactor = NIGHT_MODE_UPDATE_FACTOR;
                    }

                    vibe::libvibeModel_Sequential_AllocInit_8u_C3R(model, img_input.data, img_input.cols, img_input.rows);

                    /* Sets default model values. */
                    //vibe::libvibeModel_Sequential_SetNumberOfSamples(model, numberOfSamples);
                    vibe::libvibeModel_Sequential_SetMatchingThreshold(model, matchingThreshold);
                    vibe::libvibeModel_Sequential_SetMatchingNumber(model, matchingNumber);
                    vibe::libvibeModel_Sequential_SetUpdateFactor(model, updateFactor);
                }

                vibe::libvibeModel_Sequential_Segmentation_8u_C3R(model, img_input.data, img_output.data);
                //vibe::libvibeModel_Sequential_Update_8u_C3R(model, model_img_input.data, img_output.data);
                vibe::libvibeModel_Sequential_Update_8u_C3R(model, img_input.data, img_output.data);
                firstTime = false;
            }

        private:
            void saveConfig(){};
            void loadConfig(){};
            void save_config(cv::FileStorage &fs){};
            void load_config(cv::FileStorage &fs){};
        };

        //bgs_register(ViBe);
        static BGS_Register<ViBe> register_ViBe("ViBe");

    }
}