/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { ViewEncapsulation } from './core';
import { noUndefined } from './util';
export class CompilerConfig {
    constructor({ defaultEncapsulation = ViewEncapsulation.Emulated, useJit = true, jitDevMode = false, missingTranslation = null, preserveWhitespaces, strictInjectionParameters } = {}) {
        this.defaultEncapsulation = defaultEncapsulation;
        this.useJit = !!useJit;
        this.jitDevMode = !!jitDevMode;
        this.missingTranslation = missingTranslation;
        this.preserveWhitespaces = preserveWhitespacesDefault(noUndefined(preserveWhitespaces));
        this.strictInjectionParameters = strictInjectionParameters === true;
    }
}
export function preserveWhitespacesDefault(preserveWhitespacesOption, defaultSetting = false) {
    return preserveWhitespacesOption === null ? defaultSetting : preserveWhitespacesOption;
}
//# sourceMappingURL=data:application/json;base64,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