/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { isNgContent } from '../ml_parser/tags';
const NG_CONTENT_SELECT_ATTR = 'select';
const LINK_ELEMENT = 'link';
const LINK_STYLE_REL_ATTR = 'rel';
const LINK_STYLE_HREF_ATTR = 'href';
const LINK_STYLE_REL_VALUE = 'stylesheet';
const STYLE_ELEMENT = 'style';
const SCRIPT_ELEMENT = 'script';
const NG_NON_BINDABLE_ATTR = 'ngNonBindable';
const NG_PROJECT_AS = 'ngProjectAs';
export function preparseElement(ast) {
    let selectAttr = null;
    let hrefAttr = null;
    let relAttr = null;
    let nonBindable = false;
    let projectAs = '';
    ast.attrs.forEach(attr => {
        const lcAttrName = attr.name.toLowerCase();
        if (lcAttrName == NG_CONTENT_SELECT_ATTR) {
            selectAttr = attr.value;
        }
        else if (lcAttrName == LINK_STYLE_HREF_ATTR) {
            hrefAttr = attr.value;
        }
        else if (lcAttrName == LINK_STYLE_REL_ATTR) {
            relAttr = attr.value;
        }
        else if (attr.name == NG_NON_BINDABLE_ATTR) {
            nonBindable = true;
        }
        else if (attr.name == NG_PROJECT_AS) {
            if (attr.value.length > 0) {
                projectAs = attr.value;
            }
        }
    });
    selectAttr = normalizeNgContentSelect(selectAttr);
    const nodeName = ast.name.toLowerCase();
    let type = PreparsedElementType.OTHER;
    if (isNgContent(nodeName)) {
        type = PreparsedElementType.NG_CONTENT;
    }
    else if (nodeName == STYLE_ELEMENT) {
        type = PreparsedElementType.STYLE;
    }
    else if (nodeName == SCRIPT_ELEMENT) {
        type = PreparsedElementType.SCRIPT;
    }
    else if (nodeName == LINK_ELEMENT && relAttr == LINK_STYLE_REL_VALUE) {
        type = PreparsedElementType.STYLESHEET;
    }
    return new PreparsedElement(type, selectAttr, hrefAttr, nonBindable, projectAs);
}
export var PreparsedElementType;
(function (PreparsedElementType) {
    PreparsedElementType[PreparsedElementType["NG_CONTENT"] = 0] = "NG_CONTENT";
    PreparsedElementType[PreparsedElementType["STYLE"] = 1] = "STYLE";
    PreparsedElementType[PreparsedElementType["STYLESHEET"] = 2] = "STYLESHEET";
    PreparsedElementType[PreparsedElementType["SCRIPT"] = 3] = "SCRIPT";
    PreparsedElementType[PreparsedElementType["OTHER"] = 4] = "OTHER";
})(PreparsedElementType || (PreparsedElementType = {}));
export class PreparsedElement {
    constructor(type, selectAttr, hrefAttr, nonBindable, projectAs) {
        this.type = type;
        this.selectAttr = selectAttr;
        this.hrefAttr = hrefAttr;
        this.nonBindable = nonBindable;
        this.projectAs = projectAs;
    }
}
function normalizeNgContentSelect(selectAttr) {
    if (selectAttr === null || selectAttr.length === 0) {
        return '*';
    }
    return selectAttr;
}
//# sourceMappingURL=data:application/json;base64,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