(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/ngcc/src/ngcc_options", ["require", "exports", "@angular/compiler-cli/src/ngtsc/file_system", "@angular/compiler-cli/src/perform_compile", "@angular/compiler-cli/ngcc/src/logging/console_logger", "@angular/compiler-cli/ngcc/src/logging/logger", "@angular/compiler-cli/ngcc/src/packages/entry_point"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var file_system_1 = require("@angular/compiler-cli/src/ngtsc/file_system");
    var perform_compile_1 = require("@angular/compiler-cli/src/perform_compile");
    var console_logger_1 = require("@angular/compiler-cli/ngcc/src/logging/console_logger");
    var logger_1 = require("@angular/compiler-cli/ngcc/src/logging/logger");
    var entry_point_1 = require("@angular/compiler-cli/ngcc/src/packages/entry_point");
    /**
     * If `pathMappings` is not provided directly, then try getting it from `tsConfig`, if available.
     */
    function getPathMappingsFromTsConfig(tsConfig, projectPath) {
        if (tsConfig !== null && tsConfig.options.baseUrl !== undefined &&
            tsConfig.options.paths !== undefined) {
            return {
                baseUrl: file_system_1.resolve(projectPath, tsConfig.options.baseUrl),
                paths: tsConfig.options.paths,
            };
        }
    }
    exports.getPathMappingsFromTsConfig = getPathMappingsFromTsConfig;
    /**
     * Instantiate common utilities that are always used and fix up options with defaults, as necessary.
     *
     * NOTE: Avoid eagerly instantiating anything that might not be used when running sync/async.
     */
    function getSharedSetup(options) {
        var fileSystem = file_system_1.getFileSystem();
        var absBasePath = file_system_1.absoluteFrom(options.basePath);
        var projectPath = fileSystem.dirname(absBasePath);
        var tsConfig = options.tsConfigPath !== null ? perform_compile_1.readConfiguration(options.tsConfigPath || projectPath) : null;
        var basePath = options.basePath, targetEntryPointPath = options.targetEntryPointPath, _a = options.propertiesToConsider, propertiesToConsider = _a === void 0 ? entry_point_1.SUPPORTED_FORMAT_PROPERTIES : _a, _b = options.compileAllFormats, compileAllFormats = _b === void 0 ? true : _b, _c = options.createNewEntryPointFormats, createNewEntryPointFormats = _c === void 0 ? false : _c, _d = options.logger, logger = _d === void 0 ? new console_logger_1.ConsoleLogger(logger_1.LogLevel.info) : _d, pathMappings = options.pathMappings, _e = options.async, async = _e === void 0 ? false : _e, _f = options.errorOnFailedEntryPoint, errorOnFailedEntryPoint = _f === void 0 ? false : _f, _g = options.enableI18nLegacyMessageIdFormat, enableI18nLegacyMessageIdFormat = _g === void 0 ? true : _g, _h = options.invalidateEntryPointManifest, invalidateEntryPointManifest = _h === void 0 ? false : _h, tsConfigPath = options.tsConfigPath;
        pathMappings = options.pathMappings || getPathMappingsFromTsConfig(tsConfig, projectPath);
        if (!!options.targetEntryPointPath) {
            // targetEntryPointPath forces us to error if an entry-point fails.
            errorOnFailedEntryPoint = true;
        }
        return {
            basePath: basePath,
            targetEntryPointPath: targetEntryPointPath,
            propertiesToConsider: propertiesToConsider,
            compileAllFormats: compileAllFormats,
            createNewEntryPointFormats: createNewEntryPointFormats,
            logger: logger,
            pathMappings: pathMappings,
            async: async,
            errorOnFailedEntryPoint: errorOnFailedEntryPoint,
            enableI18nLegacyMessageIdFormat: enableI18nLegacyMessageIdFormat,
            invalidateEntryPointManifest: invalidateEntryPointManifest,
            tsConfigPath: tsConfigPath,
            fileSystem: fileSystem,
            absBasePath: absBasePath,
            projectPath: projectPath,
            tsConfig: tsConfig,
        };
    }
    exports.getSharedSetup = getSharedSetup;
});
//# sourceMappingURL=data:application/json;base64,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