/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/src/ngtsc/reflection/src/host", ["require", "exports", "typescript"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ts = require("typescript");
    exports.Decorator = {
        nodeForError: function (decorator) {
            if (decorator.node !== null) {
                return decorator.node;
            }
            else {
                // TODO(alxhub): we can't rely on narrowing until TS 3.6 is in g3.
                return decorator.synthesizedFor;
            }
        },
    };
    function isDecoratorIdentifier(exp) {
        return ts.isIdentifier(exp) ||
            ts.isPropertyAccessExpression(exp) && ts.isIdentifier(exp.expression) &&
                ts.isIdentifier(exp.name);
    }
    exports.isDecoratorIdentifier = isDecoratorIdentifier;
    /**
     * An enumeration of possible kinds of class members.
     */
    var ClassMemberKind;
    (function (ClassMemberKind) {
        ClassMemberKind[ClassMemberKind["Constructor"] = 0] = "Constructor";
        ClassMemberKind[ClassMemberKind["Getter"] = 1] = "Getter";
        ClassMemberKind[ClassMemberKind["Setter"] = 2] = "Setter";
        ClassMemberKind[ClassMemberKind["Property"] = 3] = "Property";
        ClassMemberKind[ClassMemberKind["Method"] = 4] = "Method";
    })(ClassMemberKind = exports.ClassMemberKind || (exports.ClassMemberKind = {}));
    /**
     * Possible declarations of known values, such as built-in objects/functions or TypeScript helpers.
     */
    var KnownDeclaration;
    (function (KnownDeclaration) {
        /**
         * Indicates the JavaScript global `Object` class.
         */
        KnownDeclaration[KnownDeclaration["JsGlobalObject"] = 0] = "JsGlobalObject";
        /**
         * Indicates the `__assign` TypeScript helper function.
         */
        KnownDeclaration[KnownDeclaration["TsHelperAssign"] = 1] = "TsHelperAssign";
        /**
         * Indicates the `__spread` TypeScript helper function.
         */
        KnownDeclaration[KnownDeclaration["TsHelperSpread"] = 2] = "TsHelperSpread";
        /**
         * Indicates the `__spreadArrays` TypeScript helper function.
         */
        KnownDeclaration[KnownDeclaration["TsHelperSpreadArrays"] = 3] = "TsHelperSpreadArrays";
    })(KnownDeclaration = exports.KnownDeclaration || (exports.KnownDeclaration = {}));
});
//# sourceMappingURL=data:application/json;base64,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