/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export { ALLOW_MULTIPLE_PLATFORMS as ɵALLOW_MULTIPLE_PLATFORMS } from './application_ref';
export { APP_ID_RANDOM_PROVIDER as ɵAPP_ID_RANDOM_PROVIDER } from './application_tokens';
export { defaultIterableDiffers as ɵdefaultIterableDiffers, defaultKeyValueDiffers as ɵdefaultKeyValueDiffers } from './change_detection/change_detection';
export { devModeEqual as ɵdevModeEqual, isListLikeIterable as ɵisListLikeIterable } from './change_detection/change_detection_util';
export { ChangeDetectorStatus as ɵChangeDetectorStatus, isDefaultChangeDetectionStrategy as ɵisDefaultChangeDetectionStrategy } from './change_detection/constants';
export { Console as ɵConsole } from './console';
export { getDebugNodeR2 as ɵgetDebugNodeR2 } from './debug/debug_node';
export { inject, setCurrentInjector as ɵsetCurrentInjector, ɵɵinject } from './di/injector_compatibility';
export { getInjectableDef as ɵgetInjectableDef } from './di/interface/defs';
export { INJECTOR_SCOPE as ɵINJECTOR_SCOPE } from './di/scope';
export { findLocaleData as ɵfindLocaleData, getLocaleCurrencyCode as ɵgetLocaleCurrencyCode, getLocalePluralCase as ɵgetLocalePluralCase, LocaleDataIndex as ɵLocaleDataIndex, registerLocaleData as ɵregisterLocaleData, unregisterAllLocaleData as ɵunregisterLocaleData } from './i18n/locale_data_api';
export { DEFAULT_LOCALE_ID as ɵDEFAULT_LOCALE_ID } from './i18n/localization';
export { ivyEnabled as ɵivyEnabled } from './ivy_switch';
export { ComponentFactory as ɵComponentFactory } from './linker/component_factory';
export { CodegenComponentFactoryResolver as ɵCodegenComponentFactoryResolver } from './linker/component_factory_resolver';
export { clearResolutionOfComponentResourcesQueue as ɵclearResolutionOfComponentResourcesQueue, resolveComponentResources as ɵresolveComponentResources } from './metadata/resource_loading';
export { ReflectionCapabilities as ɵReflectionCapabilities } from './reflection/reflection_capabilities';
export { allowSanitizationBypassAndThrow as ɵallowSanitizationBypassAndThrow, getSanitizationBypassType as ɵgetSanitizationBypassType, unwrapSafeValue as ɵunwrapSafeValue } from './sanitization/bypass';
export { _sanitizeHtml as ɵ_sanitizeHtml } from './sanitization/html_sanitizer';
export { _sanitizeStyle as ɵ_sanitizeStyle } from './sanitization/style_sanitizer';
export { _sanitizeUrl as ɵ_sanitizeUrl } from './sanitization/url_sanitizer';
export { looseIdentical as ɵlooseIdentical, } from './util/comparison';
export { makeDecorator as ɵmakeDecorator } from './util/decorators';
export { global as ɵglobal } from './util/global';
export { isObservable as ɵisObservable, isPromise as ɵisPromise } from './util/lang';
export { stringify as ɵstringify } from './util/stringify';
export { clearOverrides as ɵclearOverrides, initServicesIfNeeded as ɵinitServicesIfNeeded, overrideComponentView as ɵoverrideComponentView, overrideProvider as ɵoverrideProvider } from './view/index';
export { NOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR as ɵNOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR } from './view/provider';
//# sourceMappingURL=data:application/json;base64,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