/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { assertNumber, assertNumberInRange } from '../../util/assert';
export function toTStylingRange(prev, next) {
    ngDevMode && assertNumberInRange(prev, 0, 32767 /* UNSIGNED_MASK */);
    ngDevMode && assertNumberInRange(next, 0, 32767 /* UNSIGNED_MASK */);
    return (prev << 17 /* PREV_SHIFT */ | next << 2 /* NEXT_SHIFT */);
}
export function getTStylingRangePrev(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    return (tStylingRange >> 17 /* PREV_SHIFT */) & 32767 /* UNSIGNED_MASK */;
}
export function getTStylingRangePrevDuplicate(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    return (tStylingRange & 2 /* PREV_DUPLICATE */) ==
        2 /* PREV_DUPLICATE */;
}
export function setTStylingRangePrev(tStylingRange, previous) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    ngDevMode && assertNumberInRange(previous, 0, 32767 /* UNSIGNED_MASK */);
    return ((tStylingRange & ~4294836224 /* PREV_MASK */) |
        (previous << 17 /* PREV_SHIFT */));
}
export function setTStylingRangePrevDuplicate(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    return (tStylingRange | 2 /* PREV_DUPLICATE */);
}
export function getTStylingRangeNext(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    return (tStylingRange & 131068 /* NEXT_MASK */) >> 2 /* NEXT_SHIFT */;
}
export function setTStylingRangeNext(tStylingRange, next) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    ngDevMode && assertNumberInRange(next, 0, 32767 /* UNSIGNED_MASK */);
    return ((tStylingRange & ~131068 /* NEXT_MASK */) | //
        next << 2 /* NEXT_SHIFT */);
}
export function getTStylingRangeNextDuplicate(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    return (tStylingRange & 1 /* NEXT_DUPLICATE */) ===
        1 /* NEXT_DUPLICATE */;
}
export function setTStylingRangeNextDuplicate(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    return (tStylingRange | 1 /* NEXT_DUPLICATE */);
}
export function getTStylingRangeTail(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    var next = getTStylingRangeNext(tStylingRange);
    return next === 0 ? getTStylingRangePrev(tStylingRange) : next;
}
//# sourceMappingURL=data:application/json;base64,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