/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @description
 *
 * Represents a type that a Component or other object is instances of.
 *
 * An example of a `Type` is `MyCustomComponent` class, which in JavaScript is be represented by
 * the `MyCustomComponent` constructor function.
 *
 * @publicApi
 */
export var Type = Function;
export function isType(v) {
    return typeof v === 'function';
}
//# sourceMappingURL=data:application/json;base64,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