/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/language-service/src/symbols", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * An enumeration of basic types.
     *
     * @publicApi
     */
    var BuiltinType;
    (function (BuiltinType) {
        /**
         * The type is a type that can hold any other type.
         */
        BuiltinType[BuiltinType["Any"] = -1] = "Any";
        /** Unknown types are functionally identical to any. */
        BuiltinType[BuiltinType["Unknown"] = -1] = "Unknown";
        /**
         * The type of a string literal.
         */
        BuiltinType[BuiltinType["String"] = 1] = "String";
        /**
         * The type of a numeric literal.
         */
        BuiltinType[BuiltinType["Number"] = 2] = "Number";
        /**
         * The type of the `true` and `false` literals.
         */
        BuiltinType[BuiltinType["Boolean"] = 4] = "Boolean";
        /**
         * The type of the `undefined` literal.
         */
        BuiltinType[BuiltinType["Undefined"] = 8] = "Undefined";
        /**
         * the type of the `null` literal.
         */
        BuiltinType[BuiltinType["Null"] = 16] = "Null";
        /**
         * the type is an unbound type parameter.
         */
        BuiltinType[BuiltinType["Unbound"] = 32] = "Unbound";
        /**
         * Not a built-in type.
         */
        BuiltinType[BuiltinType["Other"] = 64] = "Other";
        BuiltinType[BuiltinType["Object"] = 128] = "Object";
    })(BuiltinType = exports.BuiltinType || (exports.BuiltinType = {}));
});
//# sourceMappingURL=data:application/json;base64,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