/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/** @docs-private */
export function getMatFormFieldPlaceholderConflictError() {
    return Error('Placeholder attribute and child element were both specified.');
}
/** @docs-private */
export function getMatFormFieldDuplicatedHintError(align) {
    return Error("A hint was already declared for 'align=\"" + align + "\"'.");
}
/** @docs-private */
export function getMatFormFieldMissingControlError() {
    return Error('mat-form-field must contain a MatFormFieldControl.');
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZm9ybS1maWVsZC1lcnJvcnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi9zcmMvbWF0ZXJpYWwvZm9ybS1maWVsZC9mb3JtLWZpZWxkLWVycm9ycy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7O0dBTUc7QUFFSCxvQkFBb0I7QUFDcEIsTUFBTSxVQUFVLHVDQUF1QztJQUNyRCxPQUFPLEtBQUssQ0FBQyw4REFBOEQsQ0FBQyxDQUFDO0FBQy9FLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsTUFBTSxVQUFVLGtDQUFrQyxDQUFDLEtBQWE7SUFDOUQsT0FBTyxLQUFLLENBQUMsOENBQTJDLEtBQUssU0FBSyxDQUFDLENBQUM7QUFDdEUsQ0FBQztBQUVELG9CQUFvQjtBQUNwQixNQUFNLFVBQVUsa0NBQWtDO0lBQ2hELE9BQU8sS0FBSyxDQUFDLG9EQUFvRCxDQUFDLENBQUM7QUFDckUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgTExDIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmlvL2xpY2Vuc2VcbiAqL1xuXG4vKiogQGRvY3MtcHJpdmF0ZSAqL1xuZXhwb3J0IGZ1bmN0aW9uIGdldE1hdEZvcm1GaWVsZFBsYWNlaG9sZGVyQ29uZmxpY3RFcnJvcigpOiBFcnJvciB7XG4gIHJldHVybiBFcnJvcignUGxhY2Vob2xkZXIgYXR0cmlidXRlIGFuZCBjaGlsZCBlbGVtZW50IHdlcmUgYm90aCBzcGVjaWZpZWQuJyk7XG59XG5cbi8qKiBAZG9jcy1wcml2YXRlICovXG5leHBvcnQgZnVuY3Rpb24gZ2V0TWF0Rm9ybUZpZWxkRHVwbGljYXRlZEhpbnRFcnJvcihhbGlnbjogc3RyaW5nKTogRXJyb3Ige1xuICByZXR1cm4gRXJyb3IoYEEgaGludCB3YXMgYWxyZWFkeSBkZWNsYXJlZCBmb3IgJ2FsaWduPVwiJHthbGlnbn1cIicuYCk7XG59XG5cbi8qKiBAZG9jcy1wcml2YXRlICovXG5leHBvcnQgZnVuY3Rpb24gZ2V0TWF0Rm9ybUZpZWxkTWlzc2luZ0NvbnRyb2xFcnJvcigpOiBFcnJvciB7XG4gIHJldHVybiBFcnJvcignbWF0LWZvcm0tZmllbGQgbXVzdCBjb250YWluIGEgTWF0Rm9ybUZpZWxkQ29udHJvbC4nKTtcbn1cbiJdfQ==