/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * Fake URLs and associated SVG documents used by tests.
 * The ID attribute is used to load the icons, the name attribute is only used for testing.
 * @docs-private
 */
export var FAKE_SVGS = {
    cat: '<svg><path id="meow" name="meow"></path></svg>',
    dog: '<svg><path id="woof" name="woof"></path></svg>',
    dogWithSpaces: '<svg><path id="woof says the dog" name="woof"></path></svg>',
    farmSet1: "\n    <svg>\n      <defs>\n        <g id=\"pig\" name=\"pig\"><path name=\"oink\"></path></g>\n        <g id=\"cow\" name=\"cow\"><path name=\"moo\"></path></g>\n      </defs>\n    </svg>\n  ",
    farmSet2: "\n    <svg>\n      <defs>\n        <g id=\"cow\" name=\"cow\"><path name=\"moo moo\"></path></g>\n        <g id=\"sheep\" name=\"sheep\"><path name=\"baa\"></path></g>\n      </defs>\n    </svg>\n  ",
    farmSet3: "\n    <svg>\n      <symbol id=\"duck\" name=\"duck\">\n        <path id=\"quack\" name=\"quack\"></path>\n      </symbol>\n    </svg>\n  ",
    farmSet4: "\n    <svg>\n      <defs>\n        <g id=\"pig with spaces\" name=\"pig\"><path name=\"oink\"></path></g>\n      </defs>\n    </svg>\n  ",
    farmSet5: "\n    <svg>\n      <symbol id=\"duck\" viewBox=\"0 0 13 37\">\n        <path id=\"quack\" name=\"quack\"></path>\n      </symbol>\n    </svg>\n  ",
    arrows: "\n    <svg>\n      <defs>\n        <svg id=\"left-arrow\" name=\"left-arrow\"><path name=\"left\"></path></svg>\n        <svg id=\"right-arrow\" name=\"right-arrow\"><path name=\"right\"></path></svg>\n      </defs>\n    </svg>  "
};
//# sourceMappingURL=data:application/json;base64,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