/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { __assign } from "tslib";
import { APP_INITIALIZER, ApplicationRef, NgProbeToken, NgZone, Optional, ɵgetDebugNodeR2 } from '@angular/core';
import { exportNgVar } from '../util';
var ɵ0 = function () { return ({
    'ApplicationRef': ApplicationRef,
    'NgZone': NgZone,
}); };
var CORE_TOKENS = (ɵ0)();
var INSPECT_GLOBAL_NAME = 'probe';
var CORE_TOKENS_GLOBAL_NAME = 'coreTokens';
/**
 * Returns a {@link DebugElement} for the given native DOM element, or
 * null if the given native element does not have an Angular view associated
 * with it.
 */
export function inspectNativeElementR2(element) {
    return ɵgetDebugNodeR2(element);
}
export function _createNgProbeR2(coreTokens) {
    exportNgVar(INSPECT_GLOBAL_NAME, inspectNativeElementR2);
    exportNgVar(CORE_TOKENS_GLOBAL_NAME, __assign(__assign({}, CORE_TOKENS), _ngProbeTokensToMap(coreTokens || [])));
    return function () { return inspectNativeElementR2; };
}
function _ngProbeTokensToMap(tokens) {
    return tokens.reduce(function (prev, t) { return (prev[t.name] = t.token, prev); }, {});
}
/**
 * In Ivy, we don't support NgProbe because we have our own set of testing utilities
 * with more robust functionality.
 *
 * We shouldn't bring in NgProbe because it prevents DebugNode and friends from
 * tree-shaking properly.
 */
export var ELEMENT_PROBE_PROVIDERS__POST_R3__ = [];
/**
 * Providers which support debugging Angular applications (e.g. via `ng.probe`).
 */
export var ELEMENT_PROBE_PROVIDERS__PRE_R3__ = [
    {
        provide: APP_INITIALIZER,
        useFactory: _createNgProbeR2,
        deps: [
            [NgProbeToken, new Optional()],
        ],
        multi: true,
    },
];
export var ELEMENT_PROBE_PROVIDERS = ELEMENT_PROBE_PROVIDERS__PRE_R3__;
export { ɵ0 };
//# sourceMappingURL=data:application/json;base64,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