"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Zone.__load_patch('getUserMedia', function (global, Zone, api) {
    function wrapFunctionArgs(func, source) {
        return function () {
            var args = Array.prototype.slice.call(arguments);
            var wrappedArgs = api.bindArguments(args, source ? source : func.name);
            return func.apply(this, wrappedArgs);
        };
    }
    var navigator = global['navigator'];
    if (navigator && navigator.getUserMedia) {
        navigator.getUserMedia = wrapFunctionArgs(navigator.getUserMedia);
    }
});
//# sourceMappingURL=data:application/json;base64,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