"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
(function (global) {
    // Detect and setup WTF.
    var wtfTrace = null;
    var wtfEvents = null;
    var wtfEnabled = (function () {
        var wtf = global['wtf'];
        if (wtf) {
            wtfTrace = wtf.trace;
            if (wtfTrace) {
                wtfEvents = wtfTrace.events;
                return true;
            }
        }
        return false;
    })();
    var WtfZoneSpec = /** @class */ (function () {
        function WtfZoneSpec() {
            this.name = 'WTF';
        }
        WtfZoneSpec.prototype.onFork = function (parentZoneDelegate, currentZone, targetZone, zoneSpec) {
            var retValue = parentZoneDelegate.fork(targetZone, zoneSpec);
            WtfZoneSpec.forkInstance(zonePathName(targetZone), retValue.name);
            return retValue;
        };
        WtfZoneSpec.prototype.onInvoke = function (parentZoneDelegate, currentZone, targetZone, delegate, applyThis, applyArgs, source) {
            var src = source || 'unknown';
            var scope = WtfZoneSpec.invokeScope[src];
            if (!scope) {
                scope = WtfZoneSpec.invokeScope[src] =
                    wtfEvents.createScope("Zone:invoke:" + source + "(ascii zone)");
            }
            return wtfTrace.leaveScope(scope(zonePathName(targetZone)), parentZoneDelegate.invoke(targetZone, delegate, applyThis, applyArgs, source));
        };
        WtfZoneSpec.prototype.onHandleError = function (parentZoneDelegate, currentZone, targetZone, error) {
            return parentZoneDelegate.handleError(targetZone, error);
        };
        WtfZoneSpec.prototype.onScheduleTask = function (parentZoneDelegate, currentZone, targetZone, task) {
            var key = task.type + ':' + task.source;
            var instance = WtfZoneSpec.scheduleInstance[key];
            if (!instance) {
                instance = WtfZoneSpec.scheduleInstance[key] =
                    wtfEvents.createInstance("Zone:schedule:" + key + "(ascii zone, any data)");
            }
            var retValue = parentZoneDelegate.scheduleTask(targetZone, task);
            instance(zonePathName(targetZone), shallowObj(task.data, 2));
            return retValue;
        };
        WtfZoneSpec.prototype.onInvokeTask = function (parentZoneDelegate, currentZone, targetZone, task, applyThis, applyArgs) {
            var source = task.source;
            var scope = WtfZoneSpec.invokeTaskScope[source];
            if (!scope) {
                scope = WtfZoneSpec.invokeTaskScope[source] =
                    wtfEvents.createScope("Zone:invokeTask:" + source + "(ascii zone)");
            }
            return wtfTrace.leaveScope(scope(zonePathName(targetZone)), parentZoneDelegate.invokeTask(targetZone, task, applyThis, applyArgs));
        };
        WtfZoneSpec.prototype.onCancelTask = function (parentZoneDelegate, currentZone, targetZone, task) {
            var key = task.source;
            var instance = WtfZoneSpec.cancelInstance[key];
            if (!instance) {
                instance = WtfZoneSpec.cancelInstance[key] =
                    wtfEvents.createInstance("Zone:cancel:" + key + "(ascii zone, any options)");
            }
            var retValue = parentZoneDelegate.cancelTask(targetZone, task);
            instance(zonePathName(targetZone), shallowObj(task.data, 2));
            return retValue;
        };
        WtfZoneSpec.forkInstance = wtfEnabled ? wtfEvents.createInstance('Zone:fork(ascii zone, ascii newZone)') : null;
        WtfZoneSpec.scheduleInstance = {};
        WtfZoneSpec.cancelInstance = {};
        WtfZoneSpec.invokeScope = {};
        WtfZoneSpec.invokeTaskScope = {};
        return WtfZoneSpec;
    }());
    function shallowObj(obj, depth) {
        if (!obj || !depth)
            return null;
        var out = {};
        for (var key in obj) {
            if (obj.hasOwnProperty(key)) {
                // explicit : any due to https://github.com/microsoft/TypeScript/issues/33191
                var value = obj[key];
                switch (typeof value) {
                    case 'object':
                        var name_1 = value && value.constructor && value.constructor.name;
                        value = name_1 == Object.name ? shallowObj(value, depth - 1) : name_1;
                        break;
                    case 'function':
                        value = value.name || undefined;
                        break;
                }
                out[key] = value;
            }
        }
        return out;
    }
    function zonePathName(zone) {
        var name = zone.name;
        var localZone = zone.parent;
        while (localZone != null) {
            name = localZone.name + '::' + name;
            localZone = localZone.parent;
        }
        return name;
    }
    Zone['wtfZoneSpec'] = !wtfEnabled ? null : new WtfZoneSpec();
})(typeof window === 'object' && window || typeof self === 'object' && self || global);
//# sourceMappingURL=data:application/json;base64,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