import { Component, OnInit, AfterViewInit } from '@angular/core';
import { Router } from '@angular/router';
import { HttpClient } from '@angular/common/http';
// import { Subscriber } from 'zeromq';
import {} from '@angular/common'


@Component({
  selector: 'app-home',
  templateUrl: './home.component.html',
  styleUrls: ['./home.component.css']
})
export class HomeComponent implements OnInit {
  liveViewUrl: string|null = null
  rtspViewUrl: string|null = null
  rtsp2ViewUrl: string|null = null
  rtsp3ViewUrl: string|null = null
  liveViewError: boolean = false
  recvMes: string = null

  myChart = null

  constructor(
    private router: Router,
    private httpClient: HttpClient
  ) { }

  ngOnInit(): void {
      this.retrieveImage();
      this.retrieveRTSPStream();
      this.retrieveRTSP2Stream();
      this.retrieveRTSP3Stream();
//       this.zmqSubcriber();
  }

  retrieveImage() {
    // const url = 'https://192.168.0.103:8443/app/com.securityandsafetythings.examples.helloworld/rest/example/live?time=' + Date.now();
    const url = 'rest/example/live?time=' + Date.now();
    const img = new Image();
    img.onload = (() => {
      this.liveViewUrl = url;
      this.liveViewError = false;
      
      if (this.router.url == "/home") {
        window.requestAnimationFrame(this.retrieveImage.bind(this));
      }
    });
    img.onerror = (() => {
      this.liveViewError = true
      setTimeout(() => this.retrieveImage(), 500)
    });
    img.src = url
  }

  retrieveRTSPStream() {
    // const url = 'https://192.168.0.103:8443/app/com.securityandsafetythings.examples.helloworld/rest/example/rtsp?time=' + Date.now();
    const url = 'rest/example/rtsp?time=' + Date.now();
    const img = new Image();
    img.onload = (() => {
      this.rtspViewUrl = url;
      this.liveViewError = false;
      if (this.router.url == "/home") {
        window.requestAnimationFrame(this.retrieveRTSPStream.bind(this));
      }
    });
    img.onerror = (() => {
      this.liveViewError = true
      setTimeout(() => this.retrieveRTSPStream(), 500)
    });
    img.src = url
  }

  retrieveRTSP2Stream() {
    // const url = 'https://192.168.0.103:8443/app/com.securityandsafetythings.examples.helloworld/rest/example/rtsp?time=' + Date.now();
    const url = 'rest/example/rtsp2?time=' + Date.now();
    const img = new Image();
    img.onload = (() => {
      this.rtsp2ViewUrl = url;
      this.liveViewError = false;
      if (this.router.url == "/home") {
        window.requestAnimationFrame(this.retrieveRTSP2Stream.bind(this));
      }
    });
    img.onerror = (() => {
      this.liveViewError = true
      setTimeout(() => this.retrieveRTSP2Stream(), 500)
    });
    img.src = url
  }


  retrieveRTSP3Stream() {
    // const url = 'https://192.168.0.103:8443/app/com.securityandsafetythings.examples.helloworld/rest/example/rtsp?time=' + Date.now();
    const url = 'rest/example/rtsp3?time=' + Date.now();
    const img = new Image();
    img.onload = (() => {
      this.rtsp3ViewUrl = url;
      this.liveViewError = false;
      if (this.router.url == "/home") {
        window.requestAnimationFrame(this.retrieveRTSP3Stream.bind(this));
      }
    });
    img.onerror = (() => {
      this.liveViewError = true
      setTimeout(() => this.retrieveRTSP3Stream(), 500)
    });
    img.src = url
  }

//   async zmqSubcriber() {
//     const sock = new Subscriber;
//
//     sock.connect("tcp://127.0.0.1:5556");
//     console.log("Subcriber connected to port 5556");
//
//     for await (const [topic, msg] of sock) {
//       console.log("Received message: ");
//     }
//   }
}
