/*
 * Copyright 2019-2020 by Security and Safety Things GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.securityandsafetythings.webserver.utilities;

/**
 * Interface for describing a "node" (one element of the full path) of a REST endpoint
 * <p>
 * E.g if the path is "/rest/services/abc", then "rest", "services" and "abc" each are nodes.
 */
interface HasPathNode {
    /**
     * get the path node
     *
     * @return node
     */
    String getPathNode();
}
