package com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.extractor;

import static org.opencv.core.CvType.CV_32FC1;

import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;

import com.qualcomm.qti.snpe.FloatTensor;
import com.qualcomm.qti.snpe.NeuralNetwork;
import com.qualcomm.qti.snpe.SNPE;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.DLCInference;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.Bbox;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.align.FaceAligner;

import org.jetbrains.annotations.NotNull;
import org.opencv.android.Utils;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfFloat;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class MobileFaceExtractor extends DLCInference {
    /** MobileFaceExtractor
     *  - this @MobileFaceExtractor class implement for face's feature extraction from detection
     *  result of retina face detector
     */

    /** variable for cache-pre-process process*/
    private Scalar normlized_subtraction = new Scalar(0.485f, 0.456f, 0.406f);
    private Scalar normlized_divide = new Scalar(0.229f, 0.224f, 0.225f);
    private Mat processMatRGBA;
    private Mat processMatRGB;
    private Mat processMat32F;
    private Mat processMatRawAligned;
    private Mat inputAlignedMat = new Mat(112, 112, CV_32FC1);

    /** variable for model I/O */
    protected String INPUT_LAYER;
    protected float[] floatArrayInputValues;
    protected FloatTensor inputTensor;
    protected Map<String, FloatTensor> modelInputSource;
    protected Map<String, FloatTensor> modelOutputSource;

    /** private model params*/
    private final int FEATURE_SIZE = 128;
    private FaceAligner faceAligner = null;

    protected MobileFaceExtractor(@NotNull Context context, Application application, int modelResId, NeuralNetwork.Runtime runtimeMode) {
        super(112, 112);

        final InputStream modelInputStream = context.getResources().openRawResource(modelResId);
        try {
            network = new SNPE.NeuralNetworkBuilder(application)
                    .setDebugEnabled(false)
                    .setRuntimeOrder(
                            runtimeMode,
                            NeuralNetwork.Runtime.CPU
                    )
                    .setModel(modelInputStream, modelInputStream.available())
                    .setOutputLayers("reshape_0")
                    //.setUseUserSuppliedBuffers()
                    .setCpuFallbackEnabled(true)
                    .setPerformanceProfile(NeuralNetwork.PerformanceProfile.HIGH_PERFORMANCE)
                    .build();
        } catch (IOException e) {
            e.printStackTrace();
        }

        /** setup input/output layer and pre-pair Mat for pre-process if model build success */
        if (network != null){
            floatArrayInputValues = new float[IMAGE_WIDTH * IMAGE_HEIGHT * 3];
            INPUT_LAYER = network.getInputTensorsNames().iterator().next();
            inputTensor = network.createFloatTensor(network.getInputTensorsShapes().get(INPUT_LAYER));
            modelInputSource = new HashMap<>();
            processMatRGBA = new Mat();
            processMatRGB = new Mat();
            processMat32F = new Mat();
        }
    }

    @Override
    protected void setModelConfig() {
    }

    @Override
    @Deprecated
    protected void preProcess(Bitmap inputBitmap) {
        // this extractor need extract fromm detected image with detection result

    }

    @Override
    protected void preProcess(InferenceResult inferenceResult) {
        Bbox bbox = (Bbox) inferenceResult;
        Bitmap processBitmap = bbox.getProcessBitmap();
        Utils.bitmapToMat(processBitmap, processMatRGBA);
        Imgproc.cvtColor(processMatRGBA, processMatRGB, Imgproc.COLOR_RGBA2RGB);
        processMatRawAligned = prepareAlignNative(processMatRGB, bbox);
        //!!!!!!!
        processMatRawAligned.convertTo(inputAlignedMat, CvType.CV_32F, 1.0 / 255, 0);
        Core.subtract(inputAlignedMat, normlized_subtraction, inputAlignedMat);
        Core.divide(inputAlignedMat, normlized_divide, inputAlignedMat);
        //bbox.alignInput = inputAlignedMat;

        prepairModelTensorsInput(inputAlignedMat);
    }

    protected void prepairModelTensorsInput(@NotNull Mat preprocessedMat){
        preprocessedMat.get(0,0, floatArrayInputValues);
        inputTensor.write(floatArrayInputValues, 0, floatArrayInputValues.length);
        modelInputSource.put(INPUT_LAYER,inputTensor);
    }

    public Mat prepareAlignNative(Mat frameCv, Bbox box) {
        //float landmarks[] = {
        float landmarks[][] = {
                {(float)box.landmarks[0].x,(float) box.landmarks[0].y},
                {(float)box.landmarks[1].x, (float) box.landmarks[1].y},
                {(float)box.landmarks[2].x, (float) box.landmarks[2].y},
                {(float)box.landmarks[3].x, (float) box.landmarks[3].y},
                {(float)box.landmarks[4].x, (float) box.landmarks[4].y}
        };

        Mat faceAligned = new Mat();//112, 112, CV_32FC1);
        //nativeAlign(frameCv.getNativeObjAddr(), faceAligned.getNativeObjAddr(), landmarks);

        return faceAligned;
    }

    @Override
    public InferenceResult runInference(@NotNull InferenceResult inputInference) {
        Bitmap inputBitmap = inputInference.getProcessBitmap();
        preProcess(inputInference);
        modelOutputSource = network.execute(modelInputSource);
        return postProcess(inputInference);
    }

    @Override
    protected InferenceResult postProcess(InferenceResult inferenceResult) {
        float[] outs = {};
        for (Map.Entry<String, FloatTensor> output : modelOutputSource.entrySet()) {
            FloatTensor outputTensor = output.getValue();
            switch (output.getKey()) {
                case "output0":
                    outs = new float[outputTensor.getSize()];
                    outputTensor.read(outs, 0, outs.length);
                    break;
            }
        }
        Mat cvMat = new MatOfFloat(outs).reshape(1, FEATURE_SIZE);
        Core.normalize(cvMat, cvMat);

        return new Feature(inferenceResult, cvMat);
    }

    @Override
    public void release() {
        network.release();
        releaseTensors(modelInputSource);
    }
}
