package com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.align;

import static org.opencv.core.CvType.CV_32FC1;
import static org.opencv.core.CvType.CV_32FC4;
import static org.opencv.core.CvType.CV_8U;
import static org.opencv.core.CvType.CV_8UC4;

import android.content.Context;
import android.util.Log;

import androidx.annotation.NonNull;

import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.Bbox;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.licensePlate.LPDResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.NativeInference;
import com.securityandsafetythings.examples.aiapp.utilities.ImageUtils;

import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.imgproc.Imgproc;

import java.util.Arrays;
import java.util.List;

public class LicencePlateAligner extends NativeInference {
    private Context context;

    public LicencePlateAligner(Context context) {
        this.context = context;
    }

    @Override
    public LPDResult runInference(InferenceResult inputInference) {
        LPDResult lpdResult = (LPDResult) inputInference;
        Mat fullFrameRGB = inputInference.getProcessRBBMat();
        List<Bbox> detectedPlateBboxes = lpdResult.getBboxList();
        for (Bbox bbox : detectedPlateBboxes){
            Mat croppedAlignMat = alignLicencePlate(fullFrameRGB, bbox);
            LPAlignResult alignResult = new LPAlignResult(inputInference.getProcessMedia(), croppedAlignMat);
            bbox.addResult(alignResult);
        }

        return lpdResult;
    }

    public Bbox runInference(Bbox bbox) {
        Mat fullFrameRGB = bbox.getProcessRBBMat();

        Mat croppedAlignMat = alignLicencePlate(fullFrameRGB, bbox);
        LPAlignResult alignResult = new LPAlignResult(bbox.getProcessMedia(), croppedAlignMat);
        bbox.addResult(alignResult);

        return bbox;
    }

    @NonNull
    private Mat alignLicencePlate(final Mat frameCv, @NonNull Bbox box){
        int xtl = (int)(box.landmarks[0].x), ytl = (int)(box.landmarks[0].y );
        int xtr = (int)(box.landmarks[1].x), ytr = (int)(box.landmarks[1].y );
        int xbl = (int)(box.landmarks[3].x), ybl = (int)(box.landmarks[3].y );
        int xbr = (int)(box.landmarks[4].x), ybr = (int)(box.landmarks[4].y );

        Point rects[] = {
                new Point (xtl, ytl),
                new Point (xtr, ytr),
                new Point (xbr, ybr),
                new Point (xbl, ybl)
        };
        MatOfPoint2f rectMat = new MatOfPoint2f();
        rectMat.fromArray(rects);

        double widthA = Math.sqrt(((xbr - xbl) * (xbr - xbl)) + ((ybr - ybl) * (ybr - ybl)));
        double widthB = Math.sqrt(((xtr - xtl) * (xtr - xtl)) + ((ytr - ytl) * (ytr - ytl)));
        int maxWidth = Math.max((int)(widthA), (int)(widthB));

        double heightA = Math.sqrt(((xtr - xbr) * (xtr - xbr)) + ((ytr - ybr) * (ytr - ybr)));
        double heightB = Math.sqrt((((xtl - xbl) * xtl - xbl)) + ((ytl - ybl) * (ytl - ybl)));
        int maxHeight = Math.max((int)(heightA), (int)(heightB));

        Point dsts[] = {
                new Point (0, 0),
                new Point (maxWidth - 1, 0),
                new Point (maxWidth - 1, maxHeight - 1),
                new Point (0, maxHeight - 1)
        };

        MatOfPoint2f dstMat = new MatOfPoint2f();
        dstMat.fromArray(dsts);

        Mat plateAligned = new Mat(maxHeight, maxWidth, CV_32FC1);

        Log.d("debug_warpPerspective", "rectMat = " + rectMat.dump() + " " + rectMat.type() + " " + CvType.typeToString(rectMat.type()));
        //Log.d("debug_warpPerspective", "dstMat = " + dstMat.dump() + " " + dstMat.type() + " " + CvType.typeToString(dstMat.type()));

        Mat warp_H = Imgproc.getPerspectiveTransform(rectMat, dstMat);//getAffineTransform

        //Log.d("debug_warpPerspective", frameCv.dump());

       // Log.d("debug_warpPerspective", "warp_H = "+ warp_H.dump() + " " + warp_H.type() + " " + CvType.typeToString(warp_H.type()) );

        Imgproc.warpPerspective(frameCv, plateAligned, warp_H, new org.opencv.core.Size(maxWidth, maxHeight));//warpAffine

        //float wHRatio = (1.0f*maxWidth) / (1.0f*maxHeight);
        //Log.d(LOGTAG, "alignLicencePlate " + " w " + maxWidth +  " h " + maxHeight + " ratio " + wHRatio);

        double ratio = (double) plateAligned.cols() / (double) plateAligned.rows();

        //Log.d(LOGTAG, "check ratio to divide plate, ratio = "+ ratio);

        if (ratio < 3){
            Mat cropTop = new Mat(plateAligned, new Rect(0, 0, plateAligned.cols(), plateAligned.rows()/2));
            Mat cropTopBot = new Mat(plateAligned, new Rect(0, plateAligned.rows()/2, plateAligned.cols(), plateAligned.rows()/2));

            List<Mat> src = Arrays.asList(cropTop, cropTopBot);
            plateAligned = new Mat();
            Core.hconcat(src, plateAligned);
        }


        /*Mat plateAlignedBGRA = new Mat();
        Imgproc.cvtColor(plateAligned,plateAlignedBGRA, Imgproc.COLOR_RGB2BGRA);
        ImageUtils.saveMatToCache(context, plateAlignedBGRA, "plate_");*/

        /*Log.d("debug_warpPerspective", "plateAlignedC4 = " + plateAligned.type() + " " + CvType.typeToString(plateAligned.type()));
        Log.d("debug_warpPerspective", "plateAlignedC4 sample = " + Arrays.toString(plateAligned.get(0, 0)) + "\n"
                + Arrays.toString(plateAligned.get(0, 1)) + "\n"
                + Arrays.toString(plateAligned.get(0, 2)) + "\n"
                + Arrays.toString(plateAligned.get(0, 3)) + "\n"
                + Arrays.toString(plateAligned.get(1, 1)) + "\n"
                + Arrays.toString(plateAligned.get(2, 2)) + "\n"
                + Arrays.toString(plateAligned.get(3, 3)) + "\n");
*/

        return plateAligned;
    }

    @Override
    public void release() {

    }
}
